/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.datagen.builder;

import com.teamresourceful.resourcefullib.common.datagen.CodecRecipeBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;

public class GolemConstructionRecipeBuilder
extends CodecRecipeBuilder {
    private final GolemConstructionRecipe recipe;

    public GolemConstructionRecipeBuilder(List<String> pattern, Map<String, ResourceKey<Block>> key, ResourceKey<EntityType<?>> entity, ResourceKey<Item> result, boolean visualOnly, float blockScale, float entityScale) {
        this.recipe = new GolemConstructionRecipe(pattern, key, entity, result, visualOnly, blockScale, entityScale);
    }

    @NotNull
    public Item getResult() {
        return Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(this.recipe.item()));
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        recipeOutput.accept(id, (Recipe)this.recipe, builder.build(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("recipes/golem_construction/" + id.getPath()))));
    }
}

