/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldsave.mixin;

import com.fastasyncworldsave.FastAsyncWorldSave;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LevelStorageSource.LevelStorageAccess.class})
public class LevelStorageSourceMixin {
    @Shadow
    @Final
    public LevelStorageSource.LevelDirectory levelDirectory;

    @Overwrite
    private void saveLevelData(CompoundTag compoundtag1) {
        FastAsyncWorldSave.threadPool.submit(() -> {
            Path path = this.levelDirectory.path();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NbtIo.writeCompressed((CompoundTag)compoundtag1, (Path)path1);
                Path path2 = this.levelDirectory.oldDataFile();
                Path path3 = this.levelDirectory.dataFile();
                Util.safeReplaceFile((Path)path3, (Path)path1, (Path)path2);
            }
            catch (Exception e) {
                FastAsyncWorldSave.LOGGER.error("Failed to save level {} data:" + String.valueOf(compoundtag1), (Object)path, (Object)e);
            }
        });
    }
}

