/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.apothic_attributes.commands.BonusModifierCommand;
import dev.shadowsoffire.apothic_attributes.event.ApotheosisCommandEvent;
import dev.shadowsoffire.apothic_attributes.modifiers.EquipmentSlotCompat;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiers;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.apothic_attributes.payload.ConfigPayload;
import dev.shadowsoffire.apothic_attributes.payload.CritParticlePayload;
import dev.shadowsoffire.apothic_attributes.util.AttributesUtil;
import dev.shadowsoffire.apothic_attributes.util.AuxDmgTracker;
import dev.shadowsoffire.apothic_attributes.util.LEInvoker;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class AttributeEvents {
    private static boolean noRecurse = false;
    private static Random dodgeRand = new Random();

    private boolean canBenefitFromDrawSpeed(ItemStack stack) {
        return stack.getItem() instanceof ProjectileWeaponItem || stack.getItem() instanceof TridentItem;
    }

    @SubscribeEvent
    public void drawSpeed(LivingEntityUseItemEvent.Tick e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            int mod;
            Player player = (Player)livingEntity;
            double t = player.getAttribute(ALObjects.Attributes.DRAW_SPEED).getValue() - 1.0;
            if (t == 0.0 || !this.canBenefitFromDrawSpeed(e.getItem())) {
                return;
            }
            int offset = -1;
            if (t < 0.0) {
                offset = 1;
                t = -t;
            }
            while (t > 1.0) {
                e.setDuration(e.getDuration() + offset);
                t -= 1.0;
            }
            if (t > 0.5) {
                if (e.getEntity().tickCount % 2 == 0) {
                    e.setDuration(e.getDuration() + offset);
                }
                t -= 0.5;
            }
            if (e.getEntity().tickCount % (mod = (int)Math.floor(1.0 / Math.min(1.0, t))) == 0) {
                e.setDuration(e.getDuration() + offset);
            }
            double d = t - 1.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void recordPreDamageHealth(LivingDamageEvent.Pre e) {
        e.getEntity().setData(ALObjects.Attachments.PRE_DAMAGE_HEALTH, (Object)Float.valueOf(e.getEntity().getHealth()));
    }

    @SubscribeEvent
    public void lifeStealOverheal(LivingDamageEvent.Post e) {
        Entity entity = e.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                float oldEntityHealth = ((Float)e.getEntity().getData(ALObjects.Attachments.PRE_DAMAGE_HEALTH)).floatValue();
                float lifesteal = (float)attacker.getAttributeValue(ALObjects.Attributes.LIFE_STEAL);
                float dmg = Math.min(e.getNewDamage(), oldEntityHealth);
                if ((double)lifesteal > 0.001) {
                    attacker.heal(dmg * lifesteal);
                }
                float overheal = (float)attacker.getAttributeValue(ALObjects.Attributes.OVERHEAL);
                float maxOverheal = attacker.getMaxHealth() * 0.5f;
                if (overheal > 0.0f && attacker.getAbsorptionAmount() < maxOverheal) {
                    ((LEInvoker)attacker).apoth_setInternalAbsorption(Math.min(maxOverheal, attacker.getAbsorptionAmount() + dmg * overheal));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void meleeDamageAttributes(LivingIncomingDamageEvent e) {
        if (e.getEntity().level().isClientSide || e.getEntity().isDeadOrDying()) {
            return;
        }
        if (noRecurse) {
            return;
        }
        noRecurse = true;
        Entity entity = e.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                LivingEntity target = e.getEntity();
                AuxDmgTracker.executeWith(target, tracker -> {
                    float hpDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.CURRENT_HP_DAMAGE) * target.getHealth();
                    tracker.attackWith(attacker, target, ALObjects.DamageTypes.CURRENT_HP_DAMAGE, hpDmg, null);
                    tracker.attackWith(attacker, target, ALObjects.DamageTypes.FIRE_DAMAGE, ALObjects.Attributes.FIRE_DAMAGE, AttributeEvents::applyPostFireDamage);
                    tracker.attackWith(attacker, target, ALObjects.DamageTypes.COLD_DAMAGE, ALObjects.Attributes.COLD_DAMAGE, AttributeEvents::applyPostColdDamage);
                });
                if (target.isDeadOrDying()) {
                    target.getPersistentData().putBoolean("apoth.killed_by_aux_dmg", true);
                    e.setCanceled(true);
                }
            }
        }
        noRecurse = false;
    }

    private static void applyPostFireDamage(LivingEntity attacker, LivingEntity target, DamageSource src, float dmg, float delta) {
        target.setRemainingFireTicks(target.getRemainingFireTicks() + (int)(10.0f * dmg));
    }

    private static void applyPostColdDamage(LivingEntity attacker, LivingEntity target, DamageSource src, float dmg, float delta) {
        int duration = (int)Math.min(150.0f, 15.0f * dmg);
        int amp = Math.max(0, Mth.log2((int)Math.round(dmg / 5.0f)));
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, amp));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void apothCriticalStrike(LivingIncomingDamageEvent e) {
        LivingEntity le;
        LivingEntity attacker;
        Entity entity = e.getSource().getEntity();
        LivingEntity livingEntity = attacker = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        if (attacker == null || e.getSource().is(ALObjects.Tags.CANNOT_CRITICALLY_STRIKE)) {
            return;
        }
        double critChance = attacker.getAttributeValue(ALObjects.Attributes.CRIT_CHANCE);
        RandomSource rand = e.getEntity().getRandom();
        float damage = e.getAmount();
        for (float critDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.CRIT_DAMAGE); (double)rand.nextFloat() <= critChance && critDmg > 1.0f; critDmg *= 0.85f) {
            critChance -= 1.0;
            damage += e.getAmount() * (critDmg - 1.0f);
        }
        if (damage > e.getAmount() && !attacker.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)attacker.level()), (ChunkPos)e.getEntity().chunkPosition(), (CustomPacketPayload)new CritParticlePayload(e.getEntity().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        e.setAmount(damage);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void vanillaCritDmg(CriticalHitEvent e) {
        float critDmg = (float)e.getEntity().getAttributeValue(ALObjects.Attributes.CRIT_DAMAGE);
        if (e.isVanillaCritical()) {
            e.setDamageMultiplier(Math.max(e.getDamageMultiplier(), critDmg));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void breakSpd(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed(e.getNewSpeed() * (float)e.getEntity().getAttributeValue(ALObjects.Attributes.MINING_SPEED));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockBreak(BlockDropsEvent e) {
        Entity entity = e.getBreaker();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double xpMult = living.getAttributeValue(ALObjects.Attributes.EXPERIENCE_GAINED);
            e.setDroppedExperience((int)((double)e.getDroppedExperience() * xpMult));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void mobXp(LivingExperienceDropEvent e) {
        Player player = e.getAttackingPlayer();
        if (player == null) {
            return;
        }
        double xpMult = e.getAttackingPlayer().getAttributeValue(ALObjects.Attributes.EXPERIENCE_GAINED);
        e.setDroppedExperience((int)((double)e.getDroppedExperience() * xpMult));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void heal(LivingHealEvent e) {
        float factor = (float)e.getEntity().getAttributeValue(ALObjects.Attributes.HEALING_RECEIVED);
        e.setAmount(e.getAmount() * factor);
        if (e.getAmount() <= 0.0f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void arrow(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.level().isClientSide || arrow.getPersistentData().getBoolean("apothic_attributes.arrow.done")) {
                return;
            }
            Entity entity2 = arrow.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity2;
                arrow.setBaseDamage(arrow.getBaseDamage() * le.getAttributeValue(ALObjects.Attributes.ARROW_DAMAGE));
                arrow.setDeltaMovement(arrow.getDeltaMovement().scale(le.getAttributeValue(ALObjects.Attributes.ARROW_VELOCITY)));
            }
            arrow.getPersistentData().putBoolean("apothic_attributes.arrow.done", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void projDmg(LivingIncomingDamageEvent e) {
        Entity entity;
        DamageSource src = e.getSource();
        if (src.getDirectEntity() instanceof Projectile && (entity = src.getEntity()) instanceof LivingEntity) {
            LivingEntity projOwner = (LivingEntity)entity;
            double projDmgMult = projOwner.getAttributeValue(ALObjects.Attributes.PROJECTILE_DAMAGE);
            e.setAmount(e.getAmount() * (float)projDmgMult);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(LivingIncomingDamageEvent e) {
        Mob mob;
        LivingEntity target = e.getEntity();
        if (target.level().isClientSide) {
            return;
        }
        Entity attacker = e.getSource().getDirectEntity();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            double atkRange = player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
            double atkRangeSqr = atkRange * atkRange;
            if (attacker.distanceToSqr((Entity)target) <= atkRangeSqr && AttributeEvents.isDodging(target)) {
                this.onDodge(target);
                e.setCanceled(true);
            }
        } else if (attacker instanceof Mob && (mob = (Mob)attacker).isWithinMeleeAttackRange(target) && AttributeEvents.isDodging(target)) {
            this.onDodge(target);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(ProjectileImpactEvent e) {
        LivingEntity lvTarget;
        Entity target;
        HitResult hitResult = e.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entRes = (EntityHitResult)hitResult;
            v0 = entRes.getEntity();
        } else {
            v0 = target = null;
        }
        if (target instanceof LivingEntity && AttributeEvents.isDodging(lvTarget = (LivingEntity)target)) {
            this.onDodge(lvTarget);
            e.setCanceled(true);
        }
    }

    private void onDodge(LivingEntity target) {
        target.level().playSound(null, (Entity)target, (SoundEvent)ALObjects.Sounds.DODGE.value(), SoundSource.NEUTRAL, 1.0f, 0.7f + target.getRandom().nextFloat() * 0.3f);
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            double height = target.getBbHeight();
            double width = target.getBbWidth();
            sl.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, target.getX() - width / 4.0, target.getY(), target.getZ() - width / 4.0, 6, -width / 4.0, height / 8.0, -width / 4.0, 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void fixMCF9370(ProjectileImpactEvent e) {
        if (e.isCanceled()) {
            AbstractArrow arrow;
            Entity entity;
            HitResult hitResult = e.getRayTraceResult();
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entRes = (EntityHitResult)hitResult;
                entity = entRes.getEntity();
            } else {
                entity = null;
            }
            Entity target = entity;
            Projectile proj = e.getProjectile();
            if (target != null && proj instanceof AbstractArrow && (arrow = (AbstractArrow)proj).getPierceLevel() > 0) {
                if (arrow.piercingIgnoreEntityIds == null) {
                    arrow.piercingIgnoreEntityIds = new IntOpenHashSet((int)arrow.getPierceLevel());
                }
                arrow.piercingIgnoreEntityIds.add(target.getId());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void bonusModifiers(ItemAttributeModifierEvent e) {
        ItemStack stack = e.getItemStack();
        ItemAttributeModifiers bonus = (ItemAttributeModifiers)stack.get(ALObjects.Components.BONUS_ATTRIBUTE_MODIFIERS);
        if (bonus != null) {
            bonus.modifiers().forEach(entry -> e.addModifier(entry.attribute(), entry.modifier(), entry.slot()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void stackAttrModifierCompat(ItemAttributeModifierEvent e) {
        StackAttributeModifiersEvent event = new StackAttributeModifiersEvent(e.getItemStack(), StackAttributeModifiers.fromVanilla(e.build()));
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.hasChanges()) {
            e.clearModifiers();
            StackAttributeModifiers newModifs = event.build();
            for (StackAttributeModifiers.Entry entry : newModifs.modifiers()) {
                EquipmentSlotGroup vanilla = EquipmentSlotCompat.toVanilla(entry.slots());
                if (vanilla == null) continue;
                e.addModifier(entry.attribute(), entry.modifier(), vanilla);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void bonusStackModifiers(StackAttributeModifiersEvent e) {
        ItemStack stack = e.getItemStack();
        StackAttributeModifiers bonus = (StackAttributeModifiers)stack.get(ALObjects.Components.BONUS_STACK_ATTRIBUTE_MODIFIERS);
        if (bonus != null) {
            bonus.modifiers().forEach(entry -> e.addModifier(entry.attribute(), entry.modifier(), entry.slots()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void affixModifiers(ItemAttributeModifierEvent e) {
        boolean hasBaseAR;
        boolean hasBaseAD = AttributeHelper.getModifiers(e.getModifiers(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE).filter(entry -> entry.modifier().id().equals((Object)AttributeUtil.BASE_ATTACK_DAMAGE_ID)).findAny().isPresent();
        if (hasBaseAD && !(hasBaseAR = AttributeHelper.getModifiers(e.getModifiers(), (Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE).filter(entry -> entry.modifier().id().equals((Object)AttributeUtil.BASE_ENTITY_REACH_ID)).findAny().isPresent())) {
            e.addModifier(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(AttributeUtil.BASE_ENTITY_REACH_ID, 0.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if (e.getItemStack().getItem() instanceof ElytraItem && e.getModifiers().stream().noneMatch(entry -> entry.attribute().equals(ALObjects.Attributes.ELYTRA_FLIGHT))) {
            e.addModifier(ALObjects.Attributes.ELYTRA_FLIGHT, new AttributeModifier(ApothicAttributes.loc("elytra_item_flight"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
        }
    }

    @SubscribeEvent
    public void reloads(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)ALConfig.makeReloader());
    }

    @SubscribeEvent
    public void cmds(RegisterCommandsEvent e) {
        LiteralArgumentBuilder builder = Commands.literal((String)"apoth");
        NeoForge.EVENT_BUS.post((Event)new ApotheosisCommandEvent((LiteralArgumentBuilder<CommandSourceStack>)builder, e.getBuildContext()));
        e.getDispatcher().register(builder);
    }

    @SubscribeEvent
    public void cmds(ApotheosisCommandEvent e) {
        BonusModifierCommand.register(e.getRoot());
    }

    @SubscribeEvent
    public void sync(OnDatapackSyncEvent e) {
        if (e.getPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)e.getPlayer(), (CustomPacketPayload)new ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void tickDmgTrackers(EntityTickEvent.Post e) {
        if (!e.getEntity().level().isClientSide && e.getEntity().hasData(ALObjects.Attachments.AUX_DMG_TRACKER)) {
            AuxDmgTracker tracker = (AuxDmgTracker)e.getEntity().getData(ALObjects.Attachments.AUX_DMG_TRACKER);
            tracker.tick();
        }
    }

    public static int computeDodgeSeed(LivingEntity target) {
        int delta = -1640531527;
        int base = target.tickCount + target.getUUID().hashCode();
        return base + delta + (base << 6) + (base >> 2);
    }

    public static boolean isDodging(LivingEntity target) {
        double chance = target.getAttributeValue(ALObjects.Attributes.DODGE_CHANCE);
        dodgeRand.setSeed(AttributeEvents.computeDodgeSeed(target));
        return (double)dodgeRand.nextFloat() <= chance;
    }
}

