/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.event;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.advancement.ConsecutiveSleepingTrigger;
import io.github.mortuusars.chalk.advancement.PlayerSleepInfo;
import io.github.mortuusars.chalk.core.MarkSymbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;

public class CommonEvents {

    @EventBusSubscriber(modid="chalk", bus=EventBusSubscriber.Bus.GAME)
    public static class Game {
        @SubscribeEvent
        public static void advancementAward(AdvancementEvent.AdvancementEarnEvent event) {
            ResourceLocation id = event.getAdvancement().id();
            for (Map.Entry<MarkSymbol, Pair<ModConfigSpec.BooleanValue, ModConfigSpec.ConfigValue<String>>> entry : Config.Common.SYMBOL_CONFIG.entrySet()) {
                Player player;
                boolean isEnabled = (Boolean)((ModConfigSpec.BooleanValue)entry.getValue().getFirst()).get();
                String location = (String)((ModConfigSpec.ConfigValue)entry.getValue().getSecond()).get();
                if (!isEnabled || location.isEmpty() || !location.equals(id.toString()) || !((player = event.getEntity()) instanceof ServerPlayer)) continue;
                ServerPlayer player2 = (ServerPlayer)player;
                player2.displayClientMessage((Component)Component.translatable((String)"chat.chalk.symbol_unlocked", (Object[])new Object[]{Component.translatable((String)entry.getKey().getTranslationKey()).withStyle(Style.EMPTY.withColor(5481951))}), false);
                player2.playNotifySound((SoundEvent)Chalk.SoundEvents.MARK_DRAW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return;
            }
        }

        @SubscribeEvent
        public static void onSleepFinished(PlayerWakeUpEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                Optional sleepingPos;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean sleepingLongEnough = serverPlayer.isSleepingLongEnough();
                if (!sleepingLongEnough) {
                    return;
                }
                List tags = serverPlayer.getTags().stream().toList();
                ArrayList<BlockPos> sleepPositions = new ArrayList<BlockPos>();
                for (String tag : tags) {
                    if (!tag.startsWith("ChalkConsecutiveSleepPositions")) continue;
                    serverPlayer.removeTag(tag);
                    String dataStr = tag.replace("ChalkConsecutiveSleepPositions", "");
                    PlayerSleepInfo sleepInfo = PlayerSleepInfo.deserialize(dataStr);
                    sleepPositions = new ArrayList<BlockPos>(sleepInfo.sleepPositions());
                    break;
                }
                if ((sleepingPos = serverPlayer.getSleepingPos()).isPresent()) {
                    if (sleepPositions.size() > 20) {
                        sleepPositions.removeFirst();
                    }
                    sleepPositions.add((BlockPos)sleepingPos.get());
                    PlayerSleepInfo sleepInfo = new PlayerSleepInfo(sleepPositions);
                    ((ConsecutiveSleepingTrigger)((Object)Chalk.CriteriaTriggers.CONSECUTIVE_SLEEPING.value())).trigger(serverPlayer, sleepInfo);
                    String serializedDataStr = sleepInfo.serialize();
                    serverPlayer.addTag("ChalkConsecutiveSleepPositions" + serializedDataStr);
                }
            }
        }
    }
}

