/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.chalk.core.IChalkDrawingTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ChalkBoxContents(List<ItemStack> items, int glowAmount) implements TooltipComponent
{
    public static final ChalkBoxContents EMPTY = new ChalkBoxContents((List<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), 0);
    public static final Codec<ChalkBoxContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().optionalFieldOf("items", (Object)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY)).forGetter(ChalkBoxContents::items), (App)Codec.INT.optionalFieldOf("glowing_uses", (Object)0).forGetter(ChalkBoxContents::glowAmount)).apply((Applicative)instance, ChalkBoxContents::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChalkBoxContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), ChalkBoxContents::items, (StreamCodec)ByteBufCodecs.INT, ChalkBoxContents::glowAmount, ChalkBoxContents::new);

    public ChalkBoxContents {
        if (items.size() < 9) {
            items = new ArrayList<ItemStack>(items);
            while (items.size() < 9) {
                items.add(ItemStack.EMPTY);
            }
        } else if (items.size() > 9) {
            items = new ArrayList<ItemStack>(items);
            while (items.size() > 9) {
                items.remove(9);
            }
        }
    }

    public int getSelectedChalkIndex() {
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack itemInSlot = this.items().get(slot);
            if (!(itemInSlot.getItem() instanceof IChalkDrawingTool)) continue;
            return slot;
        }
        return -1;
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    @Override
    public String toString() {
        return "ChalkBoxContents{items=" + String.valueOf(this.items) + ", glowingUses=" + this.glowAmount + "}";
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty) && this.glowAmount() <= 0;
    }

    public static class Mutable {
        private List<ItemStack> items;
        private int glowingUses;

        public Mutable(ChalkBoxContents contents) {
            this.items = new ArrayList<ItemStack>(contents.items());
            this.glowingUses = contents.glowAmount();
        }

        public List<ItemStack> getItems() {
            return this.items;
        }

        public Mutable setItems(@NotNull List<ItemStack> items) {
            this.items = items;
            return this;
        }

        public Mutable setItem(ItemStack stack, int slot) {
            this.items.set(slot, stack);
            return this;
        }

        public int getGlowingUses() {
            return this.glowingUses;
        }

        public Mutable setGlowingUses(int uses) {
            this.glowingUses = uses;
            return this;
        }

        public Mutable clear() {
            this.items.clear();
            this.glowingUses = 0;
            return this;
        }

        public ChalkBoxContents toImmutable() {
            return new ChalkBoxContents(List.copyOf(this.items), this.glowingUses);
        }
    }
}

