/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.behavior;

import com.aetherteam.aether.item.AetherItems;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.init.DAItems;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public interface DaCauldronInteraction {
    public static final Map<String, CauldronInteraction.InteractionMap> INTERACTIONS = new Object2ObjectArrayMap();
    public static final CauldronInteraction.InteractionMap POISON = DaCauldronInteraction.newInteractionMap("poison");
    public static final CauldronInteraction FILL_POISON = (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.emptyBucket((Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (BlockState)((Block)DABlocks.POISON_CAULDRON.get()).defaultBlockState(), (SoundEvent)SoundEvents.BUCKET_EMPTY);
    public static final CauldronInteraction FILL_POISON_SKYROOT = (blockState, level, blockPos, player, hand, itemStack) -> DaCauldronInteraction.emptySkyrootBucket(level, blockPos, player, hand, itemStack, ((Block)DABlocks.POISON_CAULDRON.get()).defaultBlockState());

    private static ItemInteractionResult emptySkyrootBucket(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state) {
        if (!level.isClientSide()) {
            Item item = stack.getItem();
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get())));
            player.awardStat(Stats.FILL_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            level.setBlockAndUpdate(pos, state);
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public static CauldronInteraction.InteractionMap newInteractionMap(String pName) {
        Object2ObjectOpenHashMap object2objectopenhashmap = new Object2ObjectOpenHashMap();
        object2objectopenhashmap.defaultReturnValue((state, level, pos, player, hand, stack) -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
        CauldronInteraction.InteractionMap cauldroninteraction$interactionmap = new CauldronInteraction.InteractionMap(pName, (Map)object2objectopenhashmap);
        INTERACTIONS.put(pName, cauldroninteraction$interactionmap);
        return cauldroninteraction$interactionmap;
    }

    public static void bootStrap() {
        POISON.map().put(Items.BUCKET, (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)new ItemStack((ItemLike)DAItems.PLACEABLE_POISON_BUCKET.get()), state -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
        POISON.map().put((Item)AetherItems.SKYROOT_BUCKET.get(), (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)new ItemStack((ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get()), state -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
        CauldronInteraction.EMPTY.map().put((Item)AetherItems.SKYROOT_POISON_BUCKET.get(), FILL_POISON_SKYROOT);
        CauldronInteraction.EMPTY.map().put((Item)DAItems.PLACEABLE_POISON_BUCKET.get(), FILL_POISON);
        POISON.map().put(Items.BUCKET, (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)new ItemStack((ItemLike)DAItems.PLACEABLE_POISON_BUCKET.get()), state -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
        POISON.map().put((Item)AetherItems.SKYROOT_BUCKET.get(), (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)new ItemStack((ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get()), state -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
    }
}

