/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.GentleWind;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GentleWindModel
extends EntityModel<GentleWind> {
    public final ModelPart[] body = new ModelPart[4];
    public final ModelPart head;
    public final ModelPart root;
    private final ModelPart[] bodyRot = new ModelPart[4];

    public GentleWindModel(ModelPart root) {
        this.body[0] = root.getChild("body_0");
        this.body[1] = root.getChild("body_1");
        this.body[2] = root.getChild("body_2");
        this.body[3] = root.getChild("body_3");
        this.bodyRot[0] = this.body[0].getChild("body_rot_0");
        this.bodyRot[1] = this.body[1].getChild("body_rot_1");
        this.bodyRot[2] = this.body[2].getChild("body_rot_2");
        this.bodyRot[3] = this.body[3].getChild("body_rot_3");
        this.head = root.getChild("head");
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body_0 = partdefinition.addOrReplaceChild("body_0", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_0.addOrReplaceChild("body_rot_0", CubeListBuilder.create().texOffs(12, 12).addBox(-3.0f, -2.0f, -6.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.5f, (float)0.0f));
        PartDefinition body_1 = partdefinition.addOrReplaceChild("body_1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_1.addOrReplaceChild("body_rot_1", CubeListBuilder.create().texOffs(12, 4).addBox(-3.0f, -2.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.5f, (float)0.0f));
        PartDefinition body_2 = partdefinition.addOrReplaceChild("body_2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_2.addOrReplaceChild("body_rot_2", CubeListBuilder.create().texOffs(0, 8).addBox(-3.0f, -2.0f, 4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.5f, (float)0.0f));
        PartDefinition body_3 = partdefinition.addOrReplaceChild("body_3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_3.addOrReplaceChild("body_rot_3", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, 9.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -7.5f, -11.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 0).addBox(-2.0f, -5.5f, -13.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 17).addBox(0.0f, -8.5f, -11.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(GentleWind entity, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.body.length; ++i) {
            float currentTick = (entity.tickCount + i * 5) % 400;
            this.bodyRot[i].zRot = currentTick < 20.0f ? Mth.lerp((float)partialTicks, (float)0.0f, (float)0.31415927f) + currentTick * 0.31415927f : Mth.lerp((float)0.02f, (float)0.0f, (float)this.bodyRot[i].zRot);
            this.body[i].xRot = Mth.lerp((float)0.8f, (float)0.0f, (float)(headPitch * ((float)Math.PI / 180) * (float)i * 0.15f - this.body[i].xRot));
            this.body[i].yRot = Mth.lerp((float)0.9f, (float)0.0f, (float)(netHeadYaw * ((float)Math.PI / 180) * (float)i * 0.3f - this.body[i].yRot * 0.7f));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
    }
}

