/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.datagen.registry;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.builders.AetherPlacedFeatureBuilders;
import com.aetherteam.aether.world.placementmodifier.DungeonBlacklistFilter;
import com.aetherteam.aether.world.placementmodifier.ImprovedLayerPlacementModifier;
import com.aetherteam.nitrogen.data.resources.builders.NitrogenPlacedFeatureBuilders;
import io.github.razordevs.deep_aether.datagen.registry.DAConfiguredFeatures;
import io.github.razordevs.deep_aether.world.placementmodifier.ImprovedRarityFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class DAPlacedFeatures {
    public static final ResourceKey<PlacedFeature> POISON_LAKE_PLACEMENT = DAPlacedFeatures.createKey("poison_lake");
    public static final ResourceKey<PlacedFeature> AERCLOUD_LAKE_PLACEMENT = DAPlacedFeatures.createKey("aercloud_lake");
    public static final ResourceKey<PlacedFeature> POISON_SPRING_PLACEMENT = DAPlacedFeatures.createKey("poison_spring");
    public static final ResourceKey<PlacedFeature> AERGLOW_FOREST_TREES_PLACEMENT = DAPlacedFeatures.createKey("aerglow_forest_trees_placement");
    public static final ResourceKey<PlacedFeature> FALLEN_AERGLOW_FOREST = DAPlacedFeatures.createKey("fallen_aerglow_forest");
    public static final ResourceKey<PlacedFeature> EMPTY_FALLEN_AERGLOW_FOREST = DAPlacedFeatures.createKey("empty_fallen_aerglow_forest");
    public static final ResourceKey<PlacedFeature> YAGROOT_SWAMP_TREES_PLACEMENT = DAPlacedFeatures.createKey("yagroot_swamp_trees_placement");
    public static final ResourceKey<PlacedFeature> AERGLOW_FOREST_MUSHROOM_PLACEMENT = DAPlacedFeatures.createKey("aerglow_forest_mushroom_placement");
    public static final ResourceKey<PlacedFeature> BLUE_AERGLOW_FOREST_TREES_PLACEMENT = DAPlacedFeatures.createKey("blue_aerglow_forest_trees_placement");
    public static final ResourceKey<PlacedFeature> MYSTIC_AERGLOW_FOREST_TREES_PLACEMENT = DAPlacedFeatures.createKey("mystic_aerglow_forest_trees_placement");
    public static final ResourceKey<PlacedFeature> AERLAVENDER_PATCH = DAPlacedFeatures.createKey("aerlavender_patch");
    public static final ResourceKey<PlacedFeature> AETHER_CATTAIL_PATCH = DAPlacedFeatures.createKey("aether_cattail_patch");
    public static final ResourceKey<PlacedFeature> AERGLOW_FOREST_FLOWERS = DAPlacedFeatures.createKey("aerglow_forest_flowers");
    public static final ResourceKey<PlacedFeature> MYSTIC_AERGLOW_FOREST_FLOWERS = DAPlacedFeatures.createKey("mystic_aerglow_forest_flowers");
    public static final ResourceKey<PlacedFeature> SKY_TULIPS = DAPlacedFeatures.createKey("sky_tulips");
    public static final ResourceKey<PlacedFeature> GOLDEN_ASPESS = DAPlacedFeatures.createKey("golden_aspess");
    public static final ResourceKey<PlacedFeature> ECHAISY = DAPlacedFeatures.createKey("echaisy");
    public static final ResourceKey<PlacedFeature> PATCH_SQUASH = DAPlacedFeatures.createKey("patch_squash");
    public static final ResourceKey<PlacedFeature> AERGLOW_FOREST_GRASS = DAPlacedFeatures.createKey("aerglow_forest_grass");
    public static final ResourceKey<PlacedFeature> SKYJADE = DAPlacedFeatures.createKey("skyjade_ore");
    public static final ResourceKey<PlacedFeature> MORE_SKYJADE = DAPlacedFeatures.createKey("more_skyjade_ore");
    public static final ResourceKey<PlacedFeature> ASETERITE = DAPlacedFeatures.createKey("aseterite");
    public static final ResourceKey<PlacedFeature> CLORITE = DAPlacedFeatures.createKey("clorite");
    public static final ResourceKey<PlacedFeature> AETHER_MOSS_PATCHES = DAPlacedFeatures.createKey("aether_moss");
    public static final ResourceKey<PlacedFeature> GOLDEN_GRASS_PATCH = DAPlacedFeatures.createKey("golden_grass_patch");
    public static final ResourceKey<PlacedFeature> GOLDEN_VINES_PATCH = DAPlacedFeatures.createKey("golden_vines_patch");
    public static final ResourceKey<PlacedFeature> GOLDEN_GRASS_BONEMEAL = DAPlacedFeatures.createKey("golden_grass_bonemeal");
    public static final ResourceKey<PlacedFeature> VIRULENT_QUICKSAND_PATCH = DAPlacedFeatures.createKey("virulent_quicksand_patch");
    public static final ResourceKey<PlacedFeature> GOLDEN_GROVE_TREES = DAPlacedFeatures.createKey("golden_grove_trees");
    public static final ResourceKey<PlacedFeature> STERLING_AERCLOUD_PLACEMENT = DAPlacedFeatures.createKey("sterling_aercloud");
    public static final ResourceKey<PlacedFeature> AETHER_COARSE_DIRT_PATCH = DAPlacedFeatures.createKey("aether_coarse_dirt_patch");
    public static final ResourceKey<PlacedFeature> GOLDEN_GROVE_GRASS_PATCH = DAPlacedFeatures.createKey("golden_grove_grass_patch");
    public static final ResourceKey<PlacedFeature> AERCLOUD_CLOUD = DAPlacedFeatures.createKey("aercloud_cloud");
    public static final ResourceKey<PlacedFeature> AERCLOUD_CLOUD_OVERGROWN = DAPlacedFeatures.createKey("aercloud_cloud_overgrown");
    public static final ResourceKey<PlacedFeature> AERCLOUD_RAIN_CLOUD = DAPlacedFeatures.createKey("aercloud_rain_cloud");
    public static final ResourceKey<PlacedFeature> AERCLOUD_ROOTS = DAPlacedFeatures.createKey("aercloud_roots");
    public static final ResourceKey<PlacedFeature> TOTEM = DAPlacedFeatures.createKey("totem");
    public static final ResourceKey<PlacedFeature> LUMINESCENT_SKYROOT_FOREST_TREES = DAPlacedFeatures.createKey("luminescent_skyroot_forest_trees");
    public static final ResourceKey<PlacedFeature> LUMINESCENT_SKYROOT_FOREST_VEGETATION = DAPlacedFeatures.createKey("luminescent_skyroot_forest_vegetation");
    public static final ResourceKey<PlacedFeature> AERCLOUD_TREES = DAPlacedFeatures.createKey("aercloud_trees");
    public static final ResourceKey<PlacedFeature> AERCLOUD_GRASS = DAPlacedFeatures.createKey("aercloud_grass");
    public static final ResourceKey<PlacedFeature> AERCLOUD_ROOTS_CARPET = DAPlacedFeatures.createKey("aercloud_roots_carpet");
    public static final ResourceKey<PlacedFeature> OVERGROWN_CLOUD_MUSHROOM_TREES = DAPlacedFeatures.createKey("overgrown_cloud_mushroom_trees");

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        DAPlacedFeatures.register(context, POISON_LAKE_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.POISON_LAKE_CONFIGURATION), new PlacementModifier[]{CountPlacement.of((int)20), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERCLOUD_LAKE_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.POISON_LAKE_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, POISON_SPRING_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.POISON_SPRING_CONFIGURATION), new PlacementModifier[]{CountPlacement.of((int)100), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, FALLEN_AERGLOW_FOREST, configuredFeatures.getOrThrow(DAConfiguredFeatures.FALLEN_AERGLOW_TREE), new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, EMPTY_FALLEN_AERGLOW_FOREST, configuredFeatures.getOrThrow(DAConfiguredFeatures.EMPTY_FALLEN_AERGLOW_TREE), new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, AERGLOW_FOREST_MUSHROOM_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.HUGE_LIGHTCAP_MUSHROOM), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1)));
        DAPlacedFeatures.register(context, AERGLOW_FOREST_TREES_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.ROSEROOT_AND_BLUE_ROSEROOT_TREES_PLACEMENT), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1)));
        DAPlacedFeatures.register(context, GOLDEN_GROVE_TREES, configuredFeatures.getOrThrow(DAConfiguredFeatures.SUNROOT_AND_CONBERRY_TREES_PLACEMENT), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)30, (float)0.1f, (int)1)));
        DAPlacedFeatures.register(context, YAGROOT_SWAMP_TREES_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.YAGROOT_AND_CRUDEROOT_TREES_PLACEMENT), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)20, (float)0.1f, (int)2)));
        DAPlacedFeatures.register(context, AETHER_MOSS_PATCHES, configuredFeatures.getOrThrow(DAConfiguredFeatures.AETHER_MOSS_PATCH_BONEMEAL), new PlacementModifier[]{CountPlacement.of((int)5), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, AETHER_COARSE_DIRT_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.AETHER_COARSE_DIRT_PATCH), new PlacementModifier[]{CountPlacement.of((int)1), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, InSquarePlacement.spread(), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, GOLDEN_VINES_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.GOLDEN_VINES_PATCH), new PlacementModifier[]{CountPlacement.of((int)9), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, VIRULENT_QUICKSAND_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.VIRULENT_QUICKSAND_PATCH), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, GOLDEN_GRASS_BONEMEAL, configuredFeatures.getOrThrow(DAConfiguredFeatures.GOLDEN_GRASS_BLOCK_BONEMEAL_PATCH), new PlacementModifier[]{PlacementUtils.isEmpty()});
        DAPlacedFeatures.register(context, BLUE_AERGLOW_FOREST_TREES_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.BLUE_ROSEROOT_TREES_PLACEMENT), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1)));
        DAPlacedFeatures.register(context, MYSTIC_AERGLOW_FOREST_TREES_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.ROSEROOT_TREES_PLACEMENT), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1)));
        DAPlacedFeatures.register(context, AERLAVENDER_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERLAVENDER_PATCH), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)9), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AETHER_CATTAIL_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.AETHER_CATTAILS_PATCH), new PlacementModifier[]{CountPlacement.of((int)15), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERGLOW_FOREST_FLOWERS, configuredFeatures.getOrThrow(DAConfiguredFeatures.ROSEROOT_FOREST_FLOWERS), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, MYSTIC_AERGLOW_FOREST_FLOWERS, configuredFeatures.getOrThrow(DAConfiguredFeatures.MYSTIC_ROSEROOT_FOREST_FLOWERS), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, SKY_TULIPS, configuredFeatures.getOrThrow(DAConfiguredFeatures.SKY_TULIPS), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, GOLDEN_ASPESS, configuredFeatures.getOrThrow(DAConfiguredFeatures.GOLDEN_ASPESS), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, ECHAISY, configuredFeatures.getOrThrow(DAConfiguredFeatures.ECHAISY), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERGLOW_FOREST_GRASS, configuredFeatures.getOrThrow(DAConfiguredFeatures.ROSEROOT_FOREST_GRASS), new PlacementModifier[]{CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, ASETERITE, configuredFeatures.getOrThrow(DAConfiguredFeatures.ASETERITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)1, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.belowTop((int)0))));
        DAPlacedFeatures.register(context, CLORITE, configuredFeatures.getOrThrow(DAConfiguredFeatures.CLORITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)1, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.belowTop((int)0))));
        DAPlacedFeatures.register(context, SKYJADE, configuredFeatures.getOrThrow(DAConfiguredFeatures.ORE_SKYJADE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)60))));
        DAPlacedFeatures.register(context, MORE_SKYJADE, configuredFeatures.getOrThrow(DAConfiguredFeatures.ORE_MORE_SKYJADE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128))));
        DAPlacedFeatures.register(context, GOLDEN_GRASS_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.GOLDEN_GRASS_PATCH), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)9), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, GOLDEN_GROVE_GRASS_PATCH, configuredFeatures.getOrThrow(DAConfiguredFeatures.GOLDEN_GROVE_GRASS_PATCH), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)9), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, STERLING_AERCLOUD_PLACEMENT, configuredFeatures.getOrThrow(DAConfiguredFeatures.STERLING_AERCLOUD_CONFIGURATION), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)200), (VerticalAnchor)VerticalAnchor.absolute((int)255)), ImprovedRarityFilter.onAverageOnceEvery(5.0E-4f), InSquarePlacement.spread(), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, AERCLOUD_CLOUD, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_CLOUD), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)175), (VerticalAnchor)VerticalAnchor.absolute((int)175)), CountPlacement.of((int)1), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERCLOUD_CLOUD_OVERGROWN, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_CLOUD_OVERGROWN), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)175), (VerticalAnchor)VerticalAnchor.absolute((int)175)), CountPlacement.of((int)1), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERCLOUD_RAIN_CLOUD, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_RAIN_CLOUD), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)175), (VerticalAnchor)VerticalAnchor.absolute((int)175)), CountPlacement.of((int)1), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERCLOUD_ROOTS, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_ROOTS), new PlacementModifier[]{HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.WORLD_SURFACE), CountPlacement.of((int)1), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, TOTEM, configuredFeatures.getOrThrow(DAConfiguredFeatures.TOTEM), new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, PATCH_SQUASH, configuredFeatures.getOrThrow(DAConfiguredFeatures.PATCH_SQUASH), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)100), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        DAPlacedFeatures.register(context, LUMINESCENT_SKYROOT_FOREST_TREES, configuredFeatures.getOrThrow(DAConfiguredFeatures.LUMINESCENT_SKYROOT_FOREST_TREES), new PlacementModifier[]{CountPlacement.of((int)10), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome(), BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get())), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, LUMINESCENT_SKYROOT_FOREST_VEGETATION, configuredFeatures.getOrThrow(DAConfiguredFeatures.LUMINESCENT_SKYROOT_FOREST_VEGETATION), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)1, (int)10), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)2), (int)4), BiomeFilter.biome()});
        DAPlacedFeatures.register(context, AERCLOUD_TREES, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_TREE_CONFIGURATION), new PlacementModifier[]{CountPlacement.of((int)1), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome(), BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get())), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, OVERGROWN_CLOUD_MUSHROOM_TREES, configuredFeatures.getOrThrow(DAConfiguredFeatures.OVERGROWN_CLOUD_MUSHROOM_TREES), new PlacementModifier[]{CountPlacement.of((int)2), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome(), BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get())), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, AERCLOUD_GRASS, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_GRASS), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)9), ImprovedLayerPlacementModifier.of((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), (int)4), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        DAPlacedFeatures.register(context, AERCLOUD_ROOTS_CARPET, configuredFeatures.getOrThrow(DAConfiguredFeatures.AERCLOUD_ROOTS_CARPET), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING), BiomeFilter.biome(), new DungeonBlacklistFilter()});
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        DAPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

