/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.init;

import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import io.github.razordevs.deep_aether.entity.DABoatEntity;
import io.github.razordevs.deep_aether.entity.DAChestBoatEntity;
import io.github.razordevs.deep_aether.entity.StormArrow;
import io.github.razordevs.deep_aether.entity.living.AerglowFish;
import io.github.razordevs.deep_aether.entity.living.BabyZephyr;
import io.github.razordevs.deep_aether.entity.living.GentleWind;
import io.github.razordevs.deep_aether.entity.living.Venomite;
import io.github.razordevs.deep_aether.entity.living.Windfly;
import io.github.razordevs.deep_aether.entity.living.boss.eots.EOTSController;
import io.github.razordevs.deep_aether.entity.living.boss.eots.EOTSSegment;
import io.github.razordevs.deep_aether.entity.living.quail.Quail;
import io.github.razordevs.deep_aether.entity.projectile.FireProjectile;
import io.github.razordevs.deep_aether.entity.projectile.ThrownQuailEgg;
import io.github.razordevs.deep_aether.entity.projectile.VenomiteBubble;
import io.github.razordevs.deep_aether.entity.projectile.WindCrystal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="deep_aether")
public class DAEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"deep_aether");
    public static final DeferredHolder<EntityType<?>, EntityType<DABoatEntity>> BOAT = ENTITY_TYPES.register("boat", () -> EntityType.Builder.of(DABoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build("boat"));
    public static final DeferredHolder<EntityType<?>, EntityType<DAChestBoatEntity>> CHEST_BOAT = ENTITY_TYPES.register("chest_boat", () -> EntityType.Builder.of(DAChestBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build("chest_boat"));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownQuailEgg>> QUAIL_EGG = ENTITY_TYPES.register("quail_egg", () -> EntityType.Builder.of(ThrownQuailEgg::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("quail_egg"));
    public static final DeferredHolder<EntityType<?>, EntityType<AerglowFish>> AERGLOW_FISH = DAEntities.register("aerglow_fish", EntityType.Builder.of(AerglowFish::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).clientTrackingRange(10).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<Quail>> QUAIL = DAEntities.register("quail", EntityType.Builder.of(Quail::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).clientTrackingRange(10).sized(0.35f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<Venomite>> VENOMITE = DAEntities.register("venomite", Venomite::new, 0.7f, 0.6f);
    public static final DeferredHolder<EntityType<?>, EntityType<Windfly>> WINDFLY = DAEntities.register("windfly", Windfly::new, 1.0f, 0.3f);
    public static final DeferredHolder<EntityType<?>, EntityType<EOTSController>> EOTS_CONTROLLER = DAEntities.register("eots_controller", EOTSController::new, 3.0f, 3.0f);
    public static final DeferredHolder<EntityType<?>, EntityType<EOTSSegment>> EOTS_SEGMENT = DAEntities.register("eots_segment", EOTSSegment::new, 1.0f, 1.0f);
    public static final DeferredHolder<EntityType<?>, EntityType<WindCrystal>> WIND_CRYSTAL = ENTITY_TYPES.register("wind_crystal", () -> EntityType.Builder.of(WindCrystal::new, (MobCategory)MobCategory.MISC).sized(0.85f, 0.85f).clientTrackingRange(4).updateInterval(10).fireImmune().build("wind_crystal"));
    public static final DeferredHolder<EntityType<?>, EntityType<FireProjectile>> FIRE_PROJECTILE = ENTITY_TYPES.register("fire_projectile", () -> EntityType.Builder.of(FireProjectile::new, (MobCategory)MobCategory.MISC).sized(0.35f, 0.35f).clientTrackingRange(4).fireImmune().updateInterval(10).build("fire_projectile"));
    public static final DeferredHolder<EntityType<?>, EntityType<StormArrow>> STORM_ARROW = ENTITY_TYPES.register("storm_arrow", () -> EntityType.Builder.of(StormArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("storm_arrow"));
    public static final DeferredHolder<EntityType<?>, EntityType<VenomiteBubble>> VENOMITE_BUBBLE = ENTITY_TYPES.register("venomite_bubble", () -> EntityType.Builder.of(VenomiteBubble::new, (MobCategory)MobCategory.MISC).sized(0.35f, 0.2f).clientTrackingRange(4).updateInterval(10).build("venomite_bubble"));
    public static final DeferredHolder<EntityType<?>, EntityType<BabyZephyr>> BABY_ZEPHYR = ENTITY_TYPES.register("baby_zephyr", () -> EntityType.Builder.of(BabyZephyr::new, (MobCategory)AetherMobCategory.AETHER_SKY_MONSTER).sized(1.5f, 1.0f).clientTrackingRange(10).build("baby_zephyr"));
    public static final DeferredHolder<EntityType<?>, EntityType<GentleWind>> GENTLE_WIND = DAEntities.register("gentle_wind", GentleWind::new, 1.0f, 0.3f);

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITY_TYPES.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    private static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).sized(width, height).build(name));
    }

    @SubscribeEvent
    public static void spawnPlacementRegisterEvent(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)AERGLOW_FISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.WORLD_SURFACE, (entityType, world, reason, pos, random) -> world.getBlockState(pos).getFluidState().isSourceOfType((Fluid)Fluids.WATER), RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)QUAIL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AetherAnimal::checkAetherAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)WINDFLY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DAEntities::checkWindFly, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VENOMITE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, serverLevel, spawnType, pos, random) -> serverLevel.getBlockState(pos.above()).is(Blocks.AIR), RegisterSpawnPlacementsEvent.Operation.OR);
    }

    public static boolean checkWindFly(EntityType<Windfly> animal, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return Mob.checkMobSpawnRules(animal, (LevelAccessor)level, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && EntityUtil.wholeHitboxCanSeeSky((LevelAccessor)level, (BlockPos)pos, (int)2);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)AERGLOW_FISH.get(), AerglowFish.createAttributes().build());
        event.put((EntityType)QUAIL.get(), Quail.createAttributes().build());
        event.put((EntityType)VENOMITE.get(), Venomite.createAttributes().build());
        event.put((EntityType)EOTS_SEGMENT.get(), EOTSSegment.createMobAttributes().build());
        event.put((EntityType)EOTS_CONTROLLER.get(), EOTSController.createMobAttributes().build());
        event.put((EntityType)WINDFLY.get(), Windfly.createAttributes().build());
        event.put((EntityType)BABY_ZEPHYR.get(), BabyZephyr.createMobAttributes().build());
        event.put((EntityType)GENTLE_WIND.get(), GentleWind.createMobAttributes().build());
    }
}

