/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.misc;

import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.item.miscellaneous.ConsumableItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DrinkableBucketItem
extends BucketItem
implements ConsumableItem {
    boolean canConsume = false;

    public DrinkableBucketItem(Fluid fluid, Item.Properties properties) {
        super(fluid, properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (this.canConsume) {
            if (!level.isClientSide()) {
                user.addEffect(new MobEffectInstance((Holder)AetherEffects.INEBRIATION, 500, 0));
            }
            this.consume((Item)this, stack, user);
            return stack.isEmpty() ? new ItemStack((ItemLike)Items.BUCKET) : stack;
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = DrinkableBucketItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            this.canConsume = true;
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            this.canConsume = true;
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        this.canConsume = false;
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (world.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.content == Fluids.EMPTY) {
                BucketPickup bucketpickup;
                ItemStack itemstack1;
                BlockState blockstate1 = world.getBlockState(blockpos);
                Block block = blockstate1.getBlock();
                if (block instanceof BucketPickup && !(itemstack1 = (bucketpickup = (BucketPickup)block).pickupBlock(player, (LevelAccessor)world, blockpos, blockstate1)).isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.playSound(p_150709_, 1.0f, 1.0f));
                    world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                    ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1);
                    if (!world.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack1);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)itemstack2, (boolean)world.isClientSide());
                }
                return InteractionResultHolder.fail((Object)itemstack);
            }
            BlockState blockstate = world.getBlockState(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, world, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(player, world, blockpos2, blockhitresult, itemstack)) {
                this.checkExtraContent(player, world, itemstack, blockpos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)DrinkableBucketItem.getEmptySuccessItem((ItemStack)itemstack, (Player)player), (boolean)world.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

