/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ConfiguredBoulder
extends Feature<Config> {
    public ConfiguredBoulder(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        BlockState blockstate;
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        Config config = (Config)context.config();
        while (origin.getY() > level.getMinBuildHeight() + 3 && (level.isEmptyBlock(origin.below()) || !ConfiguredBoulder.isDirt((BlockState)(blockstate = level.getBlockState(origin.below()))) && !ConfiguredBoulder.isStone((BlockState)blockstate))) {
            origin = origin.below();
        }
        if (origin.getY() <= level.getMinBuildHeight() + 3) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int i = rand.nextInt(2);
            int j = rand.nextInt(2);
            int k = rand.nextInt(2);
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(-i, -j, -k), (BlockPos)origin.offset(i, j, k))) {
                if (!(pos.distSqr((Vec3i)origin) <= (double)(f * f))) continue;
                level.setBlock(pos, config.state.getState(rand, pos), 3);
            }
            origin = origin.offset(-1 + rand.nextInt(2), -rand.nextInt(2), -1 + rand.nextInt(2));
        }
        return true;
    }

    public record Config(BlockStateProvider state) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = BlockStateProvider.CODEC.fieldOf("state").xmap(Config::new, config -> config.state).codec();
    }
}

