/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.decorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.razordevs.deep_aether.block.natural.SunrootHangerBlock;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.DADecoratorType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class SunrootHangerDecorator
extends TreeDecorator {
    public static final MapCodec<SunrootHangerDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(SunrootHangerDecorator::new, vineDecorator -> Float.valueOf(vineDecorator.probability)).stable();
    private final float probability;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)DADecoratorType.SUNROOT_HANGER.get();
    }

    public SunrootHangerDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        context.leaves().forEach(blockPos -> {
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && context.isAir(blockpos = blockPos.below())) {
                this.addHangingVine(blockpos, context);
            }
        });
    }

    private void addHangingVine(BlockPos blockPos, TreeDecorator.Context context) {
        this.placeVine(blockPos, context, (BlockState)((Block)DABlocks.SUNROOT_HANGER.get()).defaultBlockState().setValue((Property)SunrootHangerBlock.BOTTOM, (Comparable)Boolean.valueOf(false)));
        BlockPos blockpos = blockPos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            if (i != 1 && context.isAir(blockpos.below())) {
                this.placeVine(blockPos.below(i), context, (BlockState)((Block)DABlocks.SUNROOT_HANGER.get()).defaultBlockState().setValue((Property)SunrootHangerBlock.BOTTOM, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            this.placeVine(blockPos.below(i), context, (BlockState)((Block)DABlocks.SUNROOT_HANGER.get()).defaultBlockState().setValue((Property)SunrootHangerBlock.BOTTOM, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void placeVine(BlockPos blockPos, TreeDecorator.Context context, BlockState state) {
        context.setBlock(blockPos, state);
    }
}

