/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.structure.brass;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.razordevs.deep_aether.world.structure.DAStructureTypes;
import io.github.razordevs.deep_aether.world.structure.brass.BrassRoom;
import io.github.razordevs.deep_aether.world.structure.brass.processor.BrassProcessorSettings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BrassDungeonStructure
extends Structure {
    public static final MapCodec<BrassDungeonStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BrassDungeonStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY), (App)BrassProcessorSettings.CODEC.fieldOf("processor_settings").forGetter(o -> o.processors)).apply((Applicative)builder, BrassDungeonStructure::new));
    private final int minY;
    private final int rangeY;
    private final BrassProcessorSettings processors;

    public BrassDungeonStructure(Structure.StructureSettings settings, int minY, int rangeY, BrassProcessorSettings processors) {
        super(settings);
        this.minY = minY;
        this.rangeY = rangeY;
        this.processors = processors;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        ChunkPos chunkpos = context.chunkPos();
        int height = this.minY + random.nextInt(this.rangeY);
        BlockPos blockpos = new BlockPos(chunkpos.getMiddleBlockX(), height, chunkpos.getMiddleBlockZ());
        return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, context, blockpos)));
    }

    public StructureType<?> type() {
        return (StructureType)DAStructureTypes.BRASS_DUNGEON.get();
    }

    private String getRandomRoomType(RandomSource random) {
        int num = random.nextInt(77);
        if (num <= 25) {
            return "brass_dungeon_room_4";
        }
        if (num <= 45) {
            return "brass_dungeon_room_0";
        }
        if (num <= 55) {
            return "brass_dungeon_room_2";
        }
        if (num <= 70) {
            return "brass_dungeon_room_1";
        }
        return "brass_dungeon_room_3";
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos elevatedPos) {
        WorldgenRandom random = context.random();
        StructureTemplateManager templateManager = context.structureTemplateManager();
        this.buildCloudBed(builder, (RandomSource)random, elevatedPos.above().relative(Direction.NORTH, 32).above().east(5), 55, 55);
        this.buildCloudBed(builder, (RandomSource)random, elevatedPos.above().relative(Direction.NORTH, 19).below(3).east(12), 33, 33);
        Rotation rotation = Rotation.getRandom((RandomSource)random);
        this.createBossRoom((RandomSource)random, builder, elevatedPos, rotation, templateManager, true);
        rotation = rotation.getRotated(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.relative(rotation.rotate(Direction.SOUTH), 1), rotation, templateManager, false);
        rotation = rotation.getRotated(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.relative(rotation.rotate(Direction.SOUTH), 1).relative(rotation.rotate(Direction.EAST), 1), rotation, templateManager, false);
        rotation = rotation.getRotated(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.relative(rotation.rotate(Direction.EAST), 1), rotation, templateManager, false);
        rotation = rotation.getRotated(Rotation.CLOCKWISE_90);
        builder.addPiece((StructurePiece)new BrassRoom(templateManager, "door", elevatedPos.relative(rotation.rotate(Direction.EAST), 4), rotation, this.processors.roomSettings()));
    }

    private void createBossRoom(RandomSource random, StructurePiecesBuilder builder, BlockPos pos, Rotation rotation, StructureTemplateManager templateManager, boolean parent) {
        String room = this.getRandomRoomType(random);
        if (parent) {
            builder.addPiece((StructurePiece)new BrassRoom.BossRoom(templateManager, room + "_boss", pos, rotation, this.processors.bossSettings()));
        } else {
            builder.addPiece((StructurePiece)new BrassRoom(templateManager, room, pos, rotation, this.processors.roomSettings()));
        }
        builder.addPiece((StructurePiece)new BrassRoom(templateManager, "room_part_up", pos.above(32), rotation, this.processors.roomSettings()));
    }

    private void buildCloudBed(StructurePiecesBuilder builder, RandomSource random, BlockPos origin, int xBounds, int zBounds) {
        BlockPos.MutableBlockPos offset = origin.mutable().move(0, -1, 0);
        HashMap<ChunkPos, Set> chunks = new HashMap<ChunkPos, Set>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int tries = 0; tries < 100; ++tries) {
            int x = offset.getX() + random.nextInt(xBounds);
            int y = offset.getY();
            int z = offset.getZ() + random.nextInt(zBounds);
            int xTendency = random.nextInt(3) - 1;
            int zTendency = random.nextInt(3) - 1;
            for (int n = 0; n < 10; ++n) {
                x += random.nextInt(3) - 1 + xTendency;
                if (random.nextBoolean()) {
                    y += random.nextInt(3) - 1;
                }
                z += random.nextInt(3) - 1 + zTendency;
                for (int x1 = x; x1 < x + random.nextInt(4) + 3; ++x1) {
                    for (int y1 = y; y1 < y + random.nextInt(1) + 2; ++y1) {
                        for (int z1 = z; z1 < z + random.nextInt(4) + 3; ++z1) {
                            if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 + random.nextInt(2)) continue;
                            BlockPos newPosition = new BlockPos(x1, y1, z1);
                            positions.add(newPosition);
                            chunks.computeIfAbsent(new ChunkPos(newPosition), pos -> new HashSet());
                        }
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            blockPosSet.addAll(positions.stream().filter(pos -> new ChunkPos(pos).equals(chunkPos)).toList());
            builder.addPiece((StructurePiece)new LargeAercloudChunk(blockPosSet, (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), new BoundingBox(chunkPos.getMinBlockX(), origin.getY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), origin.getY(), chunkPos.getMaxBlockZ()), Direction.NORTH));
        });
    }
}

