/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.validator;

import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.BaseSpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.ScanningSpellValidator;
import dev.qther.ars_controle.spell.filter.FilterUnary;
import dev.qther.ars_controle.spell.filter.IAdaptiveFilter;
import java.util.List;
import javax.annotation.Nullable;

public class UnaryFilterValidator
extends ScanningSpellValidator<Context> {
    public static final ISpellValidator INSTANCE = new UnaryFilterValidator();

    protected Context initContext() {
        return new Context();
    }

    protected void digestSpellPart(Context context, int position, AbstractSpellPart spellPart, List<SpellValidationError> validationErrors) {
        switch (context.state.ordinal()) {
            case 0: {
                FilterUnary filter;
                if (!(spellPart instanceof FilterUnary)) break;
                context.filter = filter = (FilterUnary)spellPart;
                context.state = State.FOUND_UNARY_FILTER;
                break;
            }
            case 1: {
                if (spellPart instanceof IAdaptiveFilter) {
                    validationErrors.add((SpellValidationError)new NoChainingAdaptiveFilters(position, (AbstractSpellPart)context.filter));
                    return;
                }
                if (!(spellPart instanceof AbstractFilter)) {
                    validationErrors.add((SpellValidationError)new InvalidUnaryFilter(position, (AbstractSpellPart)context.filter));
                }
                context.state = State.LOOKING;
            }
        }
    }

    public static class Context {
        @Nullable
        FilterUnary filter;
        State state = State.LOOKING;
    }

    static enum State {
        LOOKING,
        FOUND_UNARY_FILTER;

    }

    private static class NoChainingAdaptiveFilters
    extends BaseSpellValidationError {
        public NoChainingAdaptiveFilters(int position, AbstractSpellPart spellPart) {
            super(position, spellPart, "unary_filters.no_chaining", new AbstractSpellPart[]{spellPart});
        }
    }

    private static class InvalidUnaryFilter
    extends BaseSpellValidationError {
        public InvalidUnaryFilter(int position, AbstractSpellPart spellPart) {
            super(position, spellPart, "unary_filters.next_not_filter", new AbstractSpellPart[]{spellPart});
        }
    }
}

