/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.block;

import com.shynieke.geore.config.GeOreConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class BuddingGeoreBlock
extends BuddingAmethystBlock {
    private final Supplier<? extends AmethystClusterBlock> smallSupplier;
    private final Supplier<? extends AmethystClusterBlock> mediumSupplier;
    private final Supplier<? extends AmethystClusterBlock> largeSupplier;
    private final Supplier<? extends AmethystClusterBlock> clusterSupplier;

    public BuddingGeoreBlock(BlockBehaviour.Properties properties, Supplier<? extends AmethystClusterBlock> smallSupplier, Supplier<? extends AmethystClusterBlock> mediumSupplier, Supplier<? extends AmethystClusterBlock> largeSupplier, Supplier<? extends AmethystClusterBlock> clusterSupplier) {
        super(properties);
        this.smallSupplier = smallSupplier;
        this.mediumSupplier = mediumSupplier;
        this.largeSupplier = largeSupplier;
        this.clusterSupplier = clusterSupplier;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[random.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pos.relative(direction);
            BlockState blockstate = level.getBlockState(blockpos);
            Block block = null;
            if (BuddingGeoreBlock.canClusterGrowAtState((BlockState)blockstate)) {
                block = (Block)this.smallSupplier.get();
            } else if (blockstate.is((Block)this.smallSupplier.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)this.mediumSupplier.get();
            } else if (blockstate.is((Block)this.mediumSupplier.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)this.largeSupplier.get();
            } else if (blockstate.is((Block)this.largeSupplier.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)this.clusterSupplier.get();
            }
            if (block != null) {
                BlockState budState = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                level.setBlockAndUpdate(blockpos, budState);
            }
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        if (((Boolean)GeOreConfig.COMMON.disablePistonPushForBuddingGeOre.get()).booleanValue()) {
            return PushReaction.BLOCK;
        }
        return super.getPistonPushReaction(state);
    }
}

