/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.NoColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.color.SimpleColorWithAlpha;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.DyeColor;

public interface ColorWrapper {
    public static final Map<String, KubeColor> MAP = new HashMap<String, KubeColor>();
    public static final Map<String, ChatFormatting> TEXT = (Map)Util.make(new HashMap(), map -> {
        for (ChatFormatting c : ChatFormatting.values()) {
            map.put(c.getName(), c);
        }
    });
    public static final Map<String, DyeColor> DYE = (Map)Util.make(new HashMap(), map -> {
        for (DyeColor c : DyeColor.values()) {
            map.put(c.getName(), c);
        }
    });
    public static final KubeColor NONE = ColorWrapper.createMapped(new NoColor(), "NONE", "none", "", "-", "transparent");
    public static final KubeColor BLACK = ColorWrapper.createMapped(ChatFormatting.BLACK, "BLACK", "black");
    public static final KubeColor DARK_BLUE = ColorWrapper.createMapped(ChatFormatting.DARK_BLUE, "DARK_BLUE", "dark_blue", "darkBlue");
    public static final KubeColor DARK_GREEN = ColorWrapper.createMapped(ChatFormatting.DARK_GREEN, "DARK_GREEN", "dark_green", "darkGreen");
    public static final KubeColor DARK_AQUA = ColorWrapper.createMapped(ChatFormatting.DARK_AQUA, "DARK_AQUA", "dark_aqua", "darkAqua");
    public static final KubeColor DARK_RED = ColorWrapper.createMapped(ChatFormatting.DARK_RED, "DARK_RED", "dark_red", "darkRed");
    public static final KubeColor DARK_PURPLE = ColorWrapper.createMapped(ChatFormatting.DARK_PURPLE, "DARK_PURPLE", "dark_purple", "darkPurple");
    public static final KubeColor GOLD = ColorWrapper.createMapped(ChatFormatting.GOLD, "GOLD", "gold");
    public static final KubeColor GRAY = ColorWrapper.createMapped(ChatFormatting.GRAY, "GRAY", "gray");
    public static final KubeColor DARK_GRAY = ColorWrapper.createMapped(ChatFormatting.DARK_GRAY, "DARK_GRAY", "dark_gray", "darkGray");
    public static final KubeColor BLUE = ColorWrapper.createMapped(ChatFormatting.BLUE, "BLUE", "blue");
    public static final KubeColor GREEN = ColorWrapper.createMapped(ChatFormatting.GREEN, "GREEN", "green");
    public static final KubeColor AQUA = ColorWrapper.createMapped(ChatFormatting.AQUA, "AQUA", "aqua");
    public static final KubeColor RED = ColorWrapper.createMapped(ChatFormatting.RED, "RED", "red");
    public static final KubeColor LIGHT_PURPLE = ColorWrapper.createMapped(ChatFormatting.LIGHT_PURPLE, "LIGHT_PURPLE", "light_purple", "lightPurple");
    public static final KubeColor YELLOW = ColorWrapper.createMapped(ChatFormatting.YELLOW, "YELLOW", "yellow");
    public static final KubeColor WHITE = ColorWrapper.createMapped(ChatFormatting.WHITE, "WHITE", "white");
    public static final KubeColor WHITE_DYE = ColorWrapper.createMapped(DyeColor.WHITE, "WHITE_DYE", "white_dye", "whiteDye");
    public static final KubeColor ORANGE_DYE = ColorWrapper.createMapped(DyeColor.ORANGE, "ORANGE_DYE", "orange_dye", "orangeDye");
    public static final KubeColor MAGENTA_DYE = ColorWrapper.createMapped(DyeColor.MAGENTA, "MAGENTA_DYE", "magenta_dye", "magentaDye");
    public static final KubeColor LIGHT_BLUE_DYE = ColorWrapper.createMapped(DyeColor.LIGHT_BLUE, "LIGHT_BLUE_DYE", "light_blue_dye", "lightBlueDye");
    public static final KubeColor YELLOW_DYE = ColorWrapper.createMapped(DyeColor.YELLOW, "YELLOW_DYE", "yellow_dye", "yellowDye");
    public static final KubeColor LIME_DYE = ColorWrapper.createMapped(DyeColor.LIME, "LIME_DYE", "lime_dye", "limeDye");
    public static final KubeColor PINK_DYE = ColorWrapper.createMapped(DyeColor.PINK, "PINK_DYE", "pink_dye", "pinkDye");
    public static final KubeColor GRAY_DYE = ColorWrapper.createMapped(DyeColor.GRAY, "GRAY_DYE", "gray_dye", "grayDye");
    public static final KubeColor LIGHT_GRAY_DYE = ColorWrapper.createMapped(DyeColor.LIGHT_GRAY, "LIGHT_GRAY_DYE", "lightGrayDye", "lightGrayDye");
    public static final KubeColor CYAN_DYE = ColorWrapper.createMapped(DyeColor.CYAN, "CYAN_DYE", "cyan_dye", "cyanDye");
    public static final KubeColor PURPLE_DYE = ColorWrapper.createMapped(DyeColor.PURPLE, "PURPLE_DYE", "purple_dye", "purpleDye");
    public static final KubeColor BLUE_DYE = ColorWrapper.createMapped(DyeColor.BLUE, "BLUE_DYE", "blue_dye", "blueDye");
    public static final KubeColor BROWN_DYE = ColorWrapper.createMapped(DyeColor.BROWN, "BROWN_DYE", "brown_dye", "brownDye");
    public static final KubeColor GREEN_DYE = ColorWrapper.createMapped(DyeColor.GREEN, "GREEN_DYE", "green_dye", "greenDye");
    public static final KubeColor RED_DYE = ColorWrapper.createMapped(DyeColor.RED, "RED_DYE", "red_dye", "redDye");
    public static final KubeColor BLACK_DYE = ColorWrapper.createMapped(DyeColor.BLACK, "BLACK_DYE", "black_dye", "blackDye");

    public static KubeColor of(Object o) {
        if (o instanceof KubeColor) {
            return (KubeColor)o;
        }
        if (o instanceof String) {
            String s = o.toString();
            KubeColor c = MAP.get(s);
            if (c != null) {
                return c;
            }
            if (s.startsWith("#")) {
                int col = Long.decode(s).intValue();
                return s.length() == 7 ? new SimpleColor(col) : new SimpleColorWithAlpha(col);
            }
            return NONE;
        }
        if (o instanceof Number) {
            int i = ((Number)o).intValue();
            if (i == 0) {
                return NONE;
            }
            return new SimpleColor(i);
        }
        return NONE;
    }

    public static TextColor textColorOf(Object o) {
        return ColorWrapper.of(o).kjs$createTextColor();
    }

    public static ColorRGBA colorRGBAOf(Object o) {
        return new ColorRGBA(ColorWrapper.of(o).kjs$getARGB());
    }

    public static KubeColor createMapped(Object o, String ... names) {
        KubeColor c = ColorWrapper.of(o);
        for (String s : names) {
            MAP.put(s, c);
        }
        return c;
    }

    public static KubeColor rgba(int r, int g, int b, int a) {
        return new SimpleColor(r << 16 | g << 8 | b | a << 24);
    }
}

