/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.particle;

import it.hurts.octostudios.octolib.client.particle.UIParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class ParticleSystem {
    protected static List<UIParticle> GUI_PARTICLES = new ArrayList<UIParticle>();
    protected static Map<Screen, List<UIParticle>> SCREEN_PARTICLES = new WeakHashMap<Screen, List<UIParticle>>();

    public static void tick() {
        GUI_PARTICLES.forEach(UIParticle::tick);
        SCREEN_PARTICLES.values().forEach(uiParticles -> uiParticles.forEach(UIParticle::tick));
        GUI_PARTICLES.removeIf(UIParticle::isExpired);
        SCREEN_PARTICLES.values().forEach(uiParticles -> uiParticles.removeIf(UIParticle::isExpired));
        SCREEN_PARTICLES.values().removeIf(List::isEmpty);
    }

    public static void renderScreenParticles(Screen screen, GuiGraphics guiGraphics, float partialTicks) {
        if (SCREEN_PARTICLES.containsKey(screen)) {
            SCREEN_PARTICLES.get(screen).forEach(uiParticle -> uiParticle.render(guiGraphics, partialTicks));
        }
    }

    public static void renderGuiParticles(GuiGraphics guiGraphics, float partialTicks) {
        GUI_PARTICLES.forEach(uiParticle -> uiParticle.render(guiGraphics, partialTicks));
    }
}

