/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib;

import com.mojang.logging.LogUtils;
import com.robocraft999.ars_monde_lib.registry.AMLBlocks;
import com.robocraft999.ars_monde_lib.registry.AMLItems;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="ars_monde_lib")
public class ArsMondeLib {
    public static final String MODID = "ars_monde_lib";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ars_monde_lib");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.ars_monde_lib")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> ((BlockItem)AMLBlocks.AMETHYST_VINES_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.acceptAll((Collection)AMLBlocks.BLOCK_ITEMS.getEntries().stream().map(holder -> ((Item)holder.get()).getDefaultInstance()).collect(Collectors.toList()));
        output.acceptAll((Collection)AMLItems.ITEMS.getEntries().stream().map(holder -> ((Item)holder.get()).getDefaultInstance()).collect(Collectors.toList()));
    }).build());

    public ArsMondeLib(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        AMLBlocks.BLOCKS.register(modEventBus);
        AMLBlocks.BLOCK_ITEMS.register(modEventBus);
        AMLBlocks.TRUNK_PLACER_TYPES.register(modEventBus);
        AMLItems.ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        AMLBlocks.registerFlammables();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="ars_monde_lib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
        }
    }
}

