/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib.blocks;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface AmethystVines {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty AMETHYST_BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)AMETHYST_BERRIES)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH, 1));
            float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState blockstate = (BlockState)state.setValue((Property)AMETHYST_BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState state) {
        return state.hasProperty((Property)AMETHYST_BERRIES) && (Boolean)state.getValue((Property)AMETHYST_BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int berries) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.BERRIES) != false ? berries : 0;
    }
}

