/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib.blocks;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import com.robocraft999.ars_monde_lib.blocks.AmethystVines;
import com.robocraft999.ars_monde_lib.registry.AMLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AmethystVinesPlantBlock
extends GrowingPlantBodyBlock
implements AmethystVines {
    public static final MapCodec<AmethystVinesPlantBlock> CODEC = AmethystVinesPlantBlock.simpleCodec(AmethystVinesPlantBlock::new);

    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return CODEC;
    }

    public AmethystVinesPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false);
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)AMLBlocks.AMETHYST_VINES.get();
    }

    protected BlockState updateHeadAfterConvertedFromBody(BlockState head, BlockState body) {
        return (BlockState)body.setValue((Property)AMETHYST_BERRIES, (Comparable)((Boolean)head.getValue((Property)AMETHYST_BERRIES)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return AmethystVines.use((Entity)player, state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{AMETHYST_BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)AMETHYST_BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AMETHYST_BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

