/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib.data;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.robocraft999.ars_monde_lib.blocks.AmethystVines;
import com.robocraft999.ars_monde_lib.registry.AMLBlocks;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class AMLBlockLootSubProvider
extends BlockLootSubProvider {
    protected AMLBlockLootSubProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.DEFAULT_FLAGS, registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return AMLBlocks.BLOCKS.getEntries().stream().map(e -> (Block)e.value()).toList();
    }

    protected void generate() {
        this.add((Block)AMLBlocks.AMETHYST_VINES.get(), this::createAmethystVinesDrop);
        this.add((Block)AMLBlocks.AMETHYST_VINES_PLANT.get(), this::createAmethystVinesDrop);
        this.dropSelf((Block)AMLBlocks.AMETHYST_PLANKS.get());
        this.dropSelf((Block)AMLBlocks.AMETHYST_SAPLING.get());
        this.dropSelf((Block)AMLBlocks.AMETHYST_LOG.get());
        this.dropSelf((Block)AMLBlocks.STRIPPED_AMETHYST_LOG.get());
        this.dropSelf((Block)AMLBlocks.GILDED_AMETHYST_BLACKSTONE.get());
        this.add((Block)AMLBlocks.GILDED_AMETHYST_BLACKSTONE.get(), this::createGildedStoneTable);
        this.add((Block)AMLBlocks.GILDED_AMETHYST_SMOOTH_BASALT.get(), this::createGildedStoneTable);
        this.add((Block)AMLBlocks.AMETHYST_LEAVES.get(), this.createAmethystLeavesDrop((Block)AMLBlocks.AMETHYST_LEAVES.get(), (Block)AMLBlocks.AMETHYST_SAPLING.get()));
    }

    protected LootTable.Builder createAmethystVinesDrop(Block block) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootTable.Builder builder = this.createSilkTouchOrShearsDispatchTable((Block)AMLBlocks.AMETHYST_VINES.get(), LootItem.lootTableItem(AMLBlocks.AMETHYST_VINES).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f})));
        return builder.withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)BlockRegistry.SOURCEBERRY_BUSH)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AmethystVines.AMETHYST_BERRIES, true))));
    }

    private LootTable.Builder createAmethystLeavesDrop(Block leaves, Block sapling) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        LootTable.Builder builder = this.createSilkTouchOrShearsDispatchTable(leaves, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)sapling))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_SAPLING_CHANCES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS.or(this.hasSilkTouch()).invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)1, (float)0.00125f))))));
        return builder;
    }

    private LootTable.Builder createGildedStoneTable(Block block) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }
}

