/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib.data;

import com.robocraft999.ars_monde_lib.data.AMLBlockLootSubProvider;
import com.robocraft999.ars_monde_lib.data.AMLBlockStateProvider;
import com.robocraft999.ars_monde_lib.data.AMLBlockTagProvider;
import com.robocraft999.ars_monde_lib.data.AMLItemModelProvider;
import com.robocraft999.ars_monde_lib.data.AMLItemTagProvider;
import com.robocraft999.ars_monde_lib.data.AMLLangProvider;
import com.robocraft999.ars_monde_lib.data.AMLRecipeProvider;
import com.robocraft999.ars_monde_lib.data.AMLWorldgenProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="ars_monde_lib")
public class AMLDatagenHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new AMLBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AMLItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AMLLangProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new AMLBlockTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AMLItemTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(AMLBlockLootSubProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AMLWorldgenProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AMLRecipeProvider(output, lookupProvider));
    }
}

