/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.ars_monde_lib.registry;

import com.robocraft999.ars_monde_lib.blocks.AmethystVines;
import com.robocraft999.ars_monde_lib.blocks.AmethystVinesBlock;
import com.robocraft999.ars_monde_lib.blocks.AmethystVinesPlantBlock;
import com.robocraft999.ars_monde_lib.blocks.StrippableLog;
import com.robocraft999.ars_monde_lib.registry.AMLWorldgen;
import com.robocraft999.ars_monde_lib.world.ArsNouveauTrunkPlacer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AMLBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ars_monde_lib");
    public static final DeferredRegister.Items BLOCK_ITEMS = DeferredRegister.createItems((String)"ars_monde_lib");
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACER_TYPES = DeferredRegister.create((ResourceKey)Registries.TRUNK_PLACER_TYPE, (String)"ars_monde_lib");
    private static final BlockBehaviour.Properties VINE_PLANT_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().lightLevel(AmethystVines.emission(14)).sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY);
    private static final BlockBehaviour.Properties VINE_PROPERTIES = VINE_PLANT_PROPERTIES.randomTicks();
    private static final BlockBehaviour.Properties SAP_PROP = BlockBehaviour.Properties.of().noCollission().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY);
    public static DeferredHolder<TrunkPlacerType<?>, TrunkPlacerType<ArsNouveauTrunkPlacer>> ARS_TRUNK_PLACER = TRUNK_PLACER_TYPES.register("ars_trunk_placer", () -> new TrunkPlacerType(ArsNouveauTrunkPlacer.CODEC));
    public static final DeferredBlock<Block> AMETHYST_VINES = BLOCKS.registerBlock("amethyst_vines", AmethystVinesBlock::new, VINE_PROPERTIES);
    public static final DeferredBlock<Block> AMETHYST_VINES_PLANT = BLOCKS.registerBlock("amethyst_vines_plant", AmethystVinesPlantBlock::new, VINE_PLANT_PROPERTIES);
    public static final DeferredItem<BlockItem> AMETHYST_VINES_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("amethyst_vines", AMETHYST_VINES);
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_AMETHYST_LOG = BLOCKS.register("stripped_amethyst_log", () -> AMLBlocks.log(MapColor.COLOR_PURPLE, MapColor.COLOR_PURPLE));
    public static final DeferredItem<BlockItem> STRIPPED_AMETHYST_LOG_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("stripped_amethyst_log", STRIPPED_AMETHYST_LOG);
    public static final DeferredBlock<RotatedPillarBlock> AMETHYST_LOG = BLOCKS.register("amethyst_log", () -> AMLBlocks.strippedLog(STRIPPED_AMETHYST_LOG, MapColor.COLOR_PURPLE, MapColor.COLOR_PURPLE));
    public static final DeferredItem<BlockItem> AMETHYST_LOG_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("amethyst_log", AMETHYST_LOG);
    public static final DeferredBlock<Block> AMETHYST_SAPLING = BLOCKS.register("amethyst_sapling", () -> new SaplingBlock(AMLBlocks.getGrower("amethyst_tree", AMLWorldgen.CONFIGURED_AMETHYST_TREE), SAP_PROP));
    public static final DeferredItem<BlockItem> AMETHYST_SAPLING_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("amethyst_sapling", AMETHYST_SAPLING);
    public static final DeferredBlock<LeavesBlock> AMETHYST_LEAVES = BLOCKS.register("amethyst_leaves", () -> AMLBlocks.leaves(MapColor.COLOR_PURPLE));
    public static final DeferredItem<BlockItem> AMETHYST_LEAVES_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("amethyst_leaves", AMETHYST_LEAVES);
    public static final DeferredBlock<Block> AMETHYST_PLANKS = BLOCKS.registerBlock("amethyst_planks", p -> new Block(p.mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredItem<BlockItem> AMETHYST_PLANKS_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("amethyst_planks", AMETHYST_PLANKS);
    public static final DeferredBlock<Block> GILDED_AMETHYST_BLACKSTONE = BLOCKS.registerBlock("gilded_amethyst_blackstone", Block::new, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE));
    public static final DeferredItem<BlockItem> GILDED_AMETHYST_BLACKSTONE_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("gilded_amethyst_blackstone", GILDED_AMETHYST_BLACKSTONE);
    public static final DeferredBlock<Block> GILDED_AMETHYST_SMOOTH_BASALT = BLOCKS.registerBlock("gilded_amethyst_smooth_basalt", Block::new, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.SMOOTH_BASALT));
    public static final DeferredItem<BlockItem> GILDED_AMETHYST_SMOOTH_BASALT_ITEM = BLOCK_ITEMS.registerSimpleBlockItem("gilded_amethyst_smooth_basalt", GILDED_AMETHYST_SMOOTH_BASALT);

    private static RotatedPillarBlock log(MapColor topColor, MapColor sideColor) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : sideColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    }

    private static RotatedPillarBlock strippedLog(Supplier<RotatedPillarBlock> strippedBlock, MapColor topColor, MapColor sideColor) {
        return new StrippableLog(strippedBlock, BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : sideColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    }

    public static void registerFlammables() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)AMETHYST_LOG.get(), 5, 20);
        fireblock.setFlammable((Block)STRIPPED_AMETHYST_LOG.get(), 5, 20);
        fireblock.setFlammable((Block)AMETHYST_PLANKS.get(), 5, 20);
    }

    private static TreeGrower getGrower(String name, ResourceKey<ConfiguredFeature<?, ?>> configuredFeature) {
        return new TreeGrower(name, Optional.empty(), Optional.of(configuredFeature), Optional.empty());
    }

    private static LeavesBlock leaves(MapColor color) {
        return new LeavesBlock(BlockBehaviour.Properties.of().mapColor(color).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().pushReaction(PushReaction.DESTROY).ignitedByLava());
    }
}

