/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;

public class OrganicCompostBlock
extends Block {
    public static IntegerProperty COMPOSTING = IntegerProperty.create((String)"composting", (int)0, (int)7);

    public OrganicCompostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)COMPOSTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COMPOSTING});
        super.createBlockStateDefinition(builder);
    }

    public int getMaxCompostingStage() {
        return 7;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        float chance = 0.0f;
        boolean hasWater = false;
        int maxLight = 0;
        for (BlockPos neighborPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            int light;
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.is(ModTags.COMPOST_ACTIVATORS)) {
                chance += 0.02f;
            }
            if (neighborState.getFluidState().is(FluidTags.WATER)) {
                hasWater = true;
            }
            if ((light = level.getBrightness(LightLayer.SKY, neighborPos.above())) <= maxLight) continue;
            maxLight = light;
        }
        chance += maxLight > 12 ? 0.1f : 0.05f;
        chance += hasWater ? 0.1f : 0.0f;
        if (level.getRandom().nextFloat() <= chance) {
            if (((Integer)state.getValue((Property)COMPOSTING)).intValue() == this.getMaxCompostingStage()) {
                level.setBlock(pos, ModBlocks.RICH_SOIL.get().defaultBlockState(), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)COMPOSTING, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COMPOSTING) + 1)), 3);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxCompostingStage() + 1 - (Integer)blockState.getValue((Property)COMPOSTING);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + 1.1, (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

