/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.fluids;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidSourcelinkTile
extends SourcelinkTile
implements ITooltipProvider {
    public static final int capacity = 6000;
    public final FluidTank tank = new FluidTank(6000){

        protected void onContentsChanged() {
            FluidSourcelinkTile.this.updateBlock();
            FluidSourcelinkTile.this.setChanged();
        }

        public boolean isFluidValid(@NotNull FluidStack stack) {
            return FluidSourcelinkTile.this.getSourceFromFluid(stack) > 0.0;
        }
    };
    static final Map<ResourceLocation, Double> cache = new HashMap<ResourceLocation, Double>();

    public FluidSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUID_SOURCELINK_TILE.get(), pos, state);
    }

    boolean tester(IFluidHandler tank) {
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluid = tank.getFluidInTank(i);
            if (!(this.getSourceFromFluid(fluid) > 0.0)) continue;
            return this.tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tank.getFluid(), (FluidStack)fluid);
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.level != null) {
            double sourceFromFluid;
            IFluidHandler fluidHandler;
            if (this.tank.getSpace() > 0 && this.level.getGameTime() % 20L == 0L && (fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().below(), (Object)Direction.UP)) != null && this.tester(fluidHandler)) {
                this.tank.fill(fluidHandler.drain(Math.min(2000, this.tank.getSpace()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.level.isClientSide() && this.level.getGameTime() % 20L == 0L && this.canAcceptSource() && (sourceFromFluid = this.getSourceFromFluid(this.getFluid())) > 0.0 && this.getSource() + (int)(sourceFromFluid * 500.0) <= this.getMaxSource()) {
                int maxDrain = Math.min(Mth.ceil((double)((double)(this.getMaxSource() - this.getSource()) / sourceFromFluid)), 2000);
                int drain = this.tank.drain(maxDrain, IFluidHandler.FluidAction.EXECUTE).getAmount();
                this.addSource((int)((double)drain * sourceFromFluid));
            }
        }
    }

    double getSourceFromFluid(FluidStack tank) {
        if (!tank.isEmpty() && this.level != null) {
            ResourceLocation fluid = BuiltInRegistries.FLUID.getKey((Object)tank.getFluid());
            if (cache.containsKey(fluid)) {
                return cache.get(fluid);
            }
            if (Configs.FLUID_TO_SOURCE_MAP.containsKey(fluid)) {
                double value = Configs.FLUID_TO_SOURCE_MAP.get(fluid);
                cache.put(fluid, value);
                return value;
            }
            if (tank.has(DataComponents.POTION_CONTENTS)) {
                PotionContents contents = (PotionContents)tank.get(DataComponents.POTION_CONTENTS);
                double mana = 75.0;
                HashSet<Holder> effectTypes = new HashSet<Holder>();
                assert (contents != null);
                for (MobEffectInstance e : contents.getAllEffects()) {
                    mana += (double)e.getDuration() / 50.0;
                    mana += (double)(e.getAmplifier() * 250);
                    mana += 150.0;
                    effectTypes.add(e.getEffect());
                }
                if (effectTypes.size() > 1) {
                    mana *= 1.5 * (double)(effectTypes.size() - 1);
                }
                return mana / 250.0;
            }
            List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRegistry.FLUID_SOURCELINK_RT.get());
            FluidSourcelinkRecipe find = recipes.stream().map(RecipeHolder::value).filter(r -> r.fluidType().equals((Object)fluid)).findFirst().orElse(null);
            double value = 0.0;
            if (find != null) {
                value = find.conversion_ratio();
            }
            cache.put(fluid, value);
            return value;
        }
        return 0.0;
    }

    public boolean interact(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getMaxSource() {
        return 5000;
    }

    public int getTransferRate() {
        return 2000;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.handleUpdateTag(tag, pRegistries);
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 8);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(pRegistries, tag);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.tank.readFromNBT(pRegistries, tag);
    }

    public void getTooltip(List<Component> tooltip) {
        LiquidJarTile.displayFluidTooltip(tooltip, this.getFluid());
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.source_jar.fullness", (Object[])new Object[]{this.getSource() * 100 / this.getMaxSource()}));
    }
}

