/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.fluids;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.block.fluids.AbstractTankTile;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SourceCondenserTile
extends AbstractTankTile
implements GeoBlockEntity,
ITickable {
    public boolean disabled = false;
    public static final FluidStack tester = new FluidStack((Fluid)ModRegistry.SOURCE_FLUID.get(), 1000);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SourceCondenserTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.SOURCE_CONDENSER_TILE.get(), pos, state);
        this.tank.setValidator(stack -> stack.getFluid().getFluidType() == ModRegistry.SOURCE_FLUID_TYPE.get());
    }

    public float getFluidPercentage() {
        return (float)super.getFluidAmount() / 16000.0f;
    }

    public void tick() {
        if (this.level != null && !this.level.isClientSide() && this.level.getGameTime() % 40L == 0L) {
            IFluidHandler handler;
            if (this.tank.fill(tester, IFluidHandler.FluidAction.SIMULATE) == 1000 && !this.disabled && SourceUtil.takeSourceMultipleWithParticles((BlockPos)this.getBlockPos(), (Level)this.level, (int)6, (int)((Integer)Configs.SOURCE_TO_FLUID.get())) != null) {
                this.tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.tank.isEmpty() && this.tank.getFluidAmount() >= 1000 && (handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().below(), (Object)Direction.UP)) != null && handler.fill(tester, IFluidHandler.FluidAction.SIMULATE) > 100) {
                int drain = handler.fill(tester, IFluidHandler.FluidAction.EXECUTE);
                this.tank.drain(drain, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.updateBlock();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 0, e -> e.setAndContinue(RawAnimation.begin().thenLoop("floating"))));
        data.add(new AnimationController((GeoAnimatable)this, "float_controller", 0, e -> e.setAndContinue(RawAnimation.begin().thenLoop("rotation"))));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

