/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.registry.ModRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StarItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.withDefaultNamespace((String)"item/generated");

    public StarItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "starbunclemania", existingFileHelper);
    }

    protected void registerModels() {
        this.directionScroll();
        this.generatedItem(ModRegistry.FLUID_SCROLL_DENY);
        this.generatedItem(ModRegistry.FLUID_SCROLL_ALLOW);
    }

    private void directionScroll() {
        String path = ModRegistry.DIRECTION_SCROLL.getId().getPath();
        ((ItemModelBuilder)this.withExistingParent(path, GENERATED)).texture("layer0", this.modLoc("item/blank_parchment"));
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        for (Direction side : Direction.values()) {
            builder.override().predicate(StarbuncleMania.prefix("side"), (float)side.ordinal()).model((ModelFile)this.singleTexture("item/ds/" + path + "_" + side.ordinal(), GENERATED, "layer0", this.modLoc("item/ds/" + path + "_" + String.valueOf(side)))).end();
        }
    }

    private void generatedItem(DeferredHolder<Item, Item> i) {
        String name = i.getId().getPath();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", StarbuncleMania.prefix("item/" + name));
    }

    private void blockGeneratedItem(DeferredHolder<Item, Item> i) {
        String name = i.getId().getPath();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", StarbuncleMania.prefix("block/" + name));
    }

    private void blockItem(DeferredHolder<Item, Item> i) {
        String name = i.getId().getPath();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(StarbuncleMania.prefix("block/" + name)));
    }
}

