/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class PortalPlacer {
    private PortalPlacer() {
    }

    public static boolean attemptPortalLight(Level world, BlockPos portalPos, PortalIgnitionSource ignitionSource) {
        return PortalPlacer.attemptPortalLight(world, portalPos, CustomPortalHelper.getClosestFrameBlock(world, portalPos), ignitionSource);
    }

    public static boolean attemptPortalLight(Level world, BlockPos portalPos, BlockPos framePos, PortalIgnitionSource ignitionSource) {
        Block foundationBlock = world.getBlockState(framePos).getBlock();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(foundationBlock);
        if (link == null || !link.doesIgnitionMatch(ignitionSource) || !link.canLightInDim(world.dimension().location())) {
            return false;
        }
        return PortalPlacer.createPortal(link, world, portalPos, foundationBlock, framePos, ignitionSource);
    }

    private static boolean createPortal(PortalLink link, Level world, BlockPos pos, Block foundationBlock, BlockPos framePos, PortalIgnitionSource ignitionSource) {
        Optional<PortalFrameTester> optional = link.getFrameTester().createInstanceOfPortalFrameTester().getNewPortal((LevelAccessor)world, pos, Direction.Axis.X, foundationBlock);
        if (optional.isPresent()) {
            if (optional.get().isRequestedSize(link.forcedWidth, link.forcedHeight) && link.getPortalPreIgniteEvent().attemptLight(ignitionSource.player, world, pos, framePos, ignitionSource)) {
                optional.get().lightPortal(foundationBlock);
                link.getPortalIgniteEvent().afterLight(ignitionSource.player, world, pos, framePos, ignitionSource);
            }
            return true;
        }
        return false;
    }

    public static Optional<BlockUtil.FoundRectangle> createDestinationPortal(ServerLevel world, BlockPos blockPos, BlockState frameBlock, Direction.Axis axis) {
        WorldBorder worldBorder = world.getWorldBorder();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.getBlock());
        PortalFrameTester portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester();
        int topY = Math.min(world.getMaxBuildHeight(), world.getMinBuildHeight() + world.getLogicalHeight()) - 5;
        int bottomY = world.getMinBuildHeight() + 5;
        if (world.dimension().location().equals((Object)link.dimID)) {
            if (link.portalSearchYTop != null) {
                topY = link.portalSearchYTop;
            }
            if (link.portalSearchYBottom != null) {
                bottomY = link.portalSearchYBottom;
            }
        } else {
            if (link.returnPortalSearchYTop != null) {
                topY = link.returnPortalSearchYTop;
            }
            if (link.returnPortalSearchYBottom != null) {
                bottomY = link.returnPortalSearchYBottom;
            }
        }
        for (BlockPos.MutableBlockPos mutable : BlockPos.spiralAround((BlockPos)blockPos, (int)32, (Direction)Direction.WEST, (Direction)Direction.SOUTH)) {
            BlockPos testingPos = mutable.immutable();
            if (!worldBorder.isWithinBounds(testingPos)) continue;
            for (int y = topY; y >= bottomY; --y) {
                BlockPos testRect;
                if (!PortalPlacer.canHoldPortal(world.getBlockState(testingPos.atY(y))) || (testRect = portalFrameTester.doesPortalFitAt((Level)world, testingPos.atY(y + 1), axis)) == null) continue;
                portalFrameTester.createPortal((Level)world, testRect, frameBlock, axis);
                return Optional.of(portalFrameTester.getRectangle());
            }
        }
        portalFrameTester.createPortal((Level)world, blockPos, frameBlock, axis);
        return Optional.of(portalFrameTester.getRectangle());
    }

    private static boolean canHoldPortal(BlockState state) {
        return state.isSolid();
    }
}

