/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public abstract class PortalFrameTester {
    public BlockPos lowerCorner;
    protected HashSet<Block> VALID_FRAME = null;
    protected int foundPortalBlocks;
    protected LevelAccessor world;

    public static boolean validStateInsidePortal(BlockState blockState, HashSet<Block> foundations) {
        PortalIgnitionSource ignitionSource = PortalIgnitionSource.FIRE;
        for (Block block : foundations) {
            PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(block);
            if (link == null) continue;
            ignitionSource = link.portalIgnitionSource;
            break;
        }
        if (blockState.isAir() || CustomPortalHelper.isInstanceOfCustomPortal(blockState)) {
            return true;
        }
        if (ignitionSource == PortalIgnitionSource.FIRE) {
            return blockState.is(BlockTags.FIRE);
        }
        if (ignitionSource.isWater()) {
            return blockState.getFluidState().is(FluidTags.WATER);
        }
        if (ignitionSource.isLava()) {
            return blockState.getFluidState().is(FluidTags.LAVA);
        }
        if (ignitionSource.sourceType == PortalIgnitionSource.SourceType.FLUID) {
            return BuiltInRegistries.FLUID.getKey((Object)blockState.getFluidState().getType()) == ignitionSource.ignitionSourceID;
        }
        return false;
    }

    public abstract PortalFrameTester init(LevelAccessor var1, BlockPos var2, Direction.Axis var3, Block ... var4);

    public abstract Optional<PortalFrameTester> getNewPortal(LevelAccessor var1, BlockPos var2, Direction.Axis var3, Block ... var4);

    public abstract Optional<PortalFrameTester> getOrEmpty(LevelAccessor var1, BlockPos var2, Predicate<PortalFrameTester> var3, Direction.Axis var4, Block ... var5);

    public abstract boolean isAlreadyLitPortalFrame();

    public abstract boolean isValidFrame();

    public abstract void lightPortal(Block var1);

    public abstract void createPortal(Level var1, BlockPos var2, BlockState var3, Direction.Axis var4);

    public abstract boolean isRequestedSize(int var1, int var2);

    public abstract BlockUtil.FoundRectangle getRectangle();

    public abstract Direction.Axis getAxis1();

    public abstract Direction.Axis getAxis2();

    public abstract BlockPos doesPortalFitAt(Level var1, BlockPos var2, Direction.Axis var3);

    public abstract Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle var1, Entity var2, Direction.Axis var3);

    public abstract DimensionTransition getTPTargetInPortal(ServerLevel var1, BlockUtil.FoundRectangle var2, Direction.Axis var3, Vec3 var4, Entity var5, PortalLink var6);

    protected BlockPos getLowerCorner(BlockPos blockPos, Direction.Axis axis1, Direction.Axis axis2) {
        if (!PortalFrameTester.validStateInsidePortal(this.world.getBlockState(blockPos), this.VALID_FRAME)) {
            return null;
        }
        return this.getLimitForAxis(this.getLimitForAxis(blockPos, axis1), axis2);
    }

    protected BlockPos getLimitForAxis(BlockPos blockPos, Direction.Axis axis) {
        if (blockPos == null || axis == null) {
            return null;
        }
        int offset = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.getBlockState(blockPos.relative(axis, -offset)), this.VALID_FRAME)) {
            if (++offset > 20) {
                return null;
            }
            if ((!axis.equals((Object)Direction.Axis.Y) || blockPos.getY() - offset >= this.world.getMinBuildHeight()) && (axis.equals((Object)Direction.Axis.Y) || this.world.getWorldBorder().isWithinBounds(blockPos.relative(axis, -offset)))) continue;
            return null;
        }
        return blockPos.relative(axis, -(offset - 1));
    }

    protected int getSize(Direction.Axis axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            BlockState blockState = this.world.getBlockState(this.lowerCorner.relative(axis, i));
            if (PortalFrameTester.validStateInsidePortal(blockState, this.VALID_FRAME)) continue;
            if (!this.VALID_FRAME.contains(blockState.getBlock())) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    protected boolean checkForValidFrame(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        int i;
        BlockPos.MutableBlockPos checkPos = this.lowerCorner.mutable();
        for (i = 0; i < size1; ++i) {
            if (!this.VALID_FRAME.contains(this.world.getBlockState(checkPos.relative(axis2, -1)).getBlock()) || !this.VALID_FRAME.contains(this.world.getBlockState(checkPos.relative(axis2, size2)).getBlock())) {
                return false;
            }
            checkPos = checkPos.relative(axis1, 1);
        }
        checkPos = this.lowerCorner.mutable();
        for (i = 0; i < size2; ++i) {
            if (!this.VALID_FRAME.contains(this.world.getBlockState(checkPos.relative(axis1, -1)).getBlock()) || !this.VALID_FRAME.contains(this.world.getBlockState(checkPos.relative(axis1, size1)).getBlock())) {
                return false;
            }
            checkPos = checkPos.relative(axis2, 1);
        }
        return true;
    }

    protected void countExistingPortalBlocks(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                if (!CustomPortalHelper.isInstanceOfCustomPortal(this.world.getBlockState(this.lowerCorner.relative(axis1, i).relative(axis2, j)))) continue;
                ++this.foundPortalBlocks;
            }
        }
    }

    @FunctionalInterface
    public static interface PortalFrameTesterFactory {
        public PortalFrameTester createInstanceOfPortalFrameTester();
    }
}

