/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class VanillaPortalAreaHelper
extends PortalFrameTester {
    protected final int maxWidth = 21;
    protected final int maxHeight = 21;
    protected Direction.Axis axis;
    protected int height;
    protected int width;

    @Override
    public PortalFrameTester init(LevelAccessor world, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.axis = axis;
        this.lowerCorner = this.getLowerCorner(blockPos, axis, Direction.Axis.Y);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.height = 1;
            this.width = 1;
        } else {
            this.width = this.getSize(axis, 2, 21);
            if (this.width > 0) {
                this.height = this.getSize(Direction.Axis.Y, 3, 21);
                if (this.checkForValidFrame(axis, Direction.Axis.Y, this.width, this.height)) {
                    this.countExistingPortalBlocks(axis, Direction.Axis.Y, this.width, this.height);
                } else {
                    this.lowerCorner = null;
                    this.height = 1;
                    this.width = 1;
                }
            }
        }
        return this;
    }

    @Override
    public BlockUtil.FoundRectangle getRectangle() {
        return new BlockUtil.FoundRectangle(this.lowerCorner, this.width, this.height);
    }

    @Override
    public Direction.Axis getAxis1() {
        return this.axis;
    }

    @Override
    public Direction.Axis getAxis2() {
        return Direction.Axis.Y;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(LevelAccessor worldAccess, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, customAreaHelper -> customAreaHelper.isValidFrame() && customAreaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(LevelAccessor worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Block ... foundations) {
        Optional<PortalFrameTester> optional = Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis axis2 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis2, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.width * this.height;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return !(attemptWidth != 0 && this.width != attemptWidth || attemptHeight != 0 && this.height != attemptHeight);
    }

    @Override
    public BlockPos doesPortalFitAt(Level world, BlockPos attemptPos, Direction.Axis axis) {
        if (this.isEmptySpace(world.getBlockState(attemptPos)) && this.isEmptySpace(world.getBlockState(attemptPos.relative(axis, 1))) && this.isEmptySpace(world.getBlockState(attemptPos.above())) && this.isEmptySpace(world.getBlockState(attemptPos.relative(axis, 1).above())) && this.isEmptySpace(world.getBlockState(attemptPos.above(2))) && this.isEmptySpace(world.getBlockState(attemptPos.relative(axis, 1).above(2))) && this.canHoldPortal(world, attemptPos.below()) && this.canHoldPortal(world, attemptPos.relative(axis, 1).below())) {
            return attemptPos;
        }
        return null;
    }

    protected boolean isEmptySpace(BlockState blockState) {
        return blockState.canBeReplaced() && !blockState.liquid();
    }

    protected boolean canHoldPortal(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isSolid() && blockState.isRedstoneConductor((BlockGetter)world, pos) && !this.isEmptySpace(blockState);
    }

    @Override
    public Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle arg, Entity entity, Direction.Axis portalAxis) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        double width = (float)arg.axis1Size - entityDimensions.width();
        double height = (float)arg.axis2Size - entityDimensions.height();
        double deltaX = Mth.inverseLerp((double)entity.getX(), (double)arg.minCorner.getX(), (double)((double)arg.minCorner.getX() + width));
        double deltaY = Mth.inverseLerp((double)entity.getY(), (double)arg.minCorner.getY(), (double)((double)arg.minCorner.getY() + height));
        double deltaZ = Mth.inverseLerp((double)entity.getZ(), (double)arg.minCorner.getZ(), (double)((double)arg.minCorner.getZ() + width));
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    @Override
    public DimensionTransition getTPTargetInPortal(ServerLevel world, BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 prevOffset, Entity entity, PortalLink link) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        double width = (float)portalRect.axis1Size - entityDimensions.width();
        double height = (float)portalRect.axis2Size - entityDimensions.height();
        double x = Mth.lerp((double)prevOffset.x, (double)portalRect.minCorner.getX(), (double)((double)portalRect.minCorner.getX() + width));
        double y = Mth.lerp((double)prevOffset.y, (double)portalRect.minCorner.getY(), (double)((double)portalRect.minCorner.getY() + height));
        double z = Mth.lerp((double)prevOffset.z, (double)portalRect.minCorner.getZ(), (double)((double)portalRect.minCorner.getZ() + width));
        if (portalAxis == Direction.Axis.X) {
            z = (double)portalRect.minCorner.getZ() + 0.5;
        } else if (portalAxis == Direction.Axis.Z) {
            x = (double)portalRect.minCorner.getX() + 0.5;
        }
        DimensionTransition.PostDimensionTransition post = DimensionTransition.PLAY_PORTAL_SOUND.then(entityx -> {
            entityx.placePortalTicket(portalRect.minCorner);
            link.executePostTPEvent(entityx);
        });
        return new DimensionTransition(world, new Vec3(x, y, z), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), post);
    }

    @Override
    public void lightPortal(Block frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        BlockState blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().defaultBlockState() : CustomPortalsMod.getDefaultPortalBlock().defaultBlockState(), this.axis);
        BlockPos.betweenClosed((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.relative(Direction.UP, this.height - 1).relative(this.axis, this.width - 1)).forEach(blockPos -> this.world.setBlock(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(Level world, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        Direction.Axis rotatedAxis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        for (i = -1; i < 4; ++i) {
            world.setBlockAndUpdate(pos.above(i).relative(axis, -1), frameBlock);
            world.setBlockAndUpdate(pos.above(i).relative(axis, 2), frameBlock);
            if (i < 0) continue;
            this.fillAirAroundPortal(world, pos.above(i).relative(axis, -1).relative(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.above(i).relative(axis, 2).relative(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.above(i).relative(axis, -1).relative(rotatedAxis, -1));
            this.fillAirAroundPortal(world, pos.above(i).relative(axis, 2).relative(rotatedAxis, -1));
        }
        for (i = -1; i < 3; ++i) {
            world.setBlockAndUpdate(pos.above(-1).relative(axis, i), frameBlock);
            world.setBlockAndUpdate(pos.above(3).relative(axis, i), frameBlock);
            this.fillAirAroundPortal(world, pos.above(3).relative(axis, i).relative(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.above(3).relative(axis, i).relative(rotatedAxis, -1));
        }
        this.placeLandingPad(world, pos.below().relative(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.below().relative(rotatedAxis, -1), frameBlock);
        this.placeLandingPad(world, pos.below().relative(axis, 1).relative(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.below().relative(axis, 1).relative(rotatedAxis, -1), frameBlock);
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.fillAirAroundPortal(world, pos.relative(axis, i).above(j).relative(rotatedAxis, 1));
                this.fillAirAroundPortal(world, pos.relative(axis, i).above(j).relative(rotatedAxis, -1));
            }
        }
        this.lowerCorner = pos;
        this.width = 2;
        this.height = 3;
        this.axis = axis;
        this.world = world;
        this.foundPortalBlocks = 6;
        this.lightPortal(frameBlock.getBlock());
    }

    protected void fillAirAroundPortal(Level world, BlockPos pos) {
        if (world.getBlockState(pos).isSolid() || world.getBlockState(pos).isRedstoneConductor((BlockGetter)world, pos)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    protected void placeLandingPad(Level world, BlockPos pos, BlockState frameBlock) {
        if (!world.getBlockState(pos).isSolid()) {
            world.setBlockAndUpdate(pos, frameBlock);
        }
    }
}

