/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mystic.atlantis.TagsInit;
import com.mystic.atlantis.blocks.aquatic_power.SodiumPrimedBombBlock;
import com.mystic.atlantis.blocks.base.ExtendedBlockEntity;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.datagen.Providers;
import com.mystic.atlantis.datagen.WaterAttachedToLeavesDecorator;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import com.mystic.atlantis.feature.AtlantisFeature;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.AtlantisModifierInit;
import com.mystic.atlantis.init.AtlantisSoundEventInit;
import com.mystic.atlantis.init.BlockEntityInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.EffectsInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.FluidTypesInit;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.init.POITypesInit;
import com.mystic.atlantis.init.RecipesInit;
import com.mystic.atlantis.init.ToolInit;
import com.mystic.atlantis.items.armor.BasicArmorMaterial;
import com.mystic.atlantis.particles.ModParticleTypes;
import com.mystic.atlantis.screen.LinguisticScreen;
import com.mystic.atlantis.screen.WritingScreen;
import com.mystic.atlantis.structures.AtlantisStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

@Mod(value="atlantis")
@EventBusSubscriber
public class Atlantis {
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECO_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.TREE_DECORATOR_TYPE, (String)"atlantis");
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<WaterAttachedToLeavesDecorator>> WATER_ATTACH_TO_LEAVES = TREE_DECO_TYPES.register("water_attached_to_leaves", () -> new TreeDecoratorType(WaterAttachedToLeavesDecorator.CODEC));

    public Atlantis(ModContainer container) {
        IEventBus bus = container.getEventBus();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtlantisConfig.CONFIG_SPEC);
        ModParticleTypes.PARTICLES.register(bus);
        this.onInitialize(bus);
        TREE_DECO_TYPES.register(bus);
        AtlantisFeature.init(bus);
        AtlantisStructures.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        Providers.init(bus);
    }

    public static void registerDispenserBehavior() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BlockInit.SODIUM_BOMB.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource p_123425_, @NotNull ItemStack p_123426_) {
                ServerLevel level = p_123425_.level();
                BlockPos blockpos = p_123425_.pos().relative((Direction)p_123425_.state().getValue((Property)DispenserBlock.FACING));
                SodiumPrimedBombBlock primedtnt = new SodiumPrimedBombBlock((Level)level, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null);
                level.addFreshEntity((Entity)primedtnt);
                level.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                p_123426_.shrink(1);
                return p_123426_;
            }
        });
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Atlantis.id(name));
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"atlantis", (String)id);
    }

    public void onInitialize(IEventBus bus) {
        BlockInit.init(bus);
        ItemInit.init(bus);
        BasicArmorMaterial.init(bus);
        AtlantisModifierInit.init(bus);
        BlockEntityInit.init(bus);
        FluidTypesInit.init(bus);
        FluidInit.init(bus);
        AtlantisGroupInit.init(bus);
        AtlantisEntityInit.init(bus);
        AtlantisSoundEventInit.init(bus);
        EffectsInit.init(bus);
        MenuTypeInit.init(bus);
        RecipesInit.init(bus);
        POITypesInit.init(bus);
        AtlantisDimensions.init(bus);
    }

    @SubscribeEvent
    public static void onClientSet(RegisterMenuScreensEvent event) {
        event.register((MenuType)MenuTypeInit.LINGUISTIC.get(), LinguisticScreen::new);
        event.register((MenuType)MenuTypeInit.WRITING.get(), WritingScreen::new);
    }

    @SubscribeEvent
    public static void onCommonSet(FMLCommonSetupEvent event) {
        ToolInit.init();
        TagsInit.init();
        ((ExtendedBlockEntity)BlockEntityType.SIGN).addAdditionalValidBlock((Block)BlockInit.NYMPH_SIGN.get(), (Block)BlockInit.NYMPH_WALL_SIGN.get());
        ((ExtendedBlockEntity)BlockEntityType.SIGN).addAdditionalValidBlock((Block)BlockInit.PALM_SIGN.get(), (Block)BlockInit.PALM_WALL_SIGN.get());
        Atlantis.registerDispenserBehavior();
    }
}

