/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mystic.atlantis.Atlantis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class AtlantisDimensionalEffect
extends DimensionSpecialEffects {
    public static AtlantisDimensionalEffect INSTANCE = new AtlantisDimensionalEffect();
    private static final ResourceLocation SUN_TEXTURES = Atlantis.id("textures/environment/sun.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = Atlantis.id("textures/environment/moon_phases.png");
    @Nullable
    private VertexBuffer starBuffer;

    private AtlantisDimensionalEffect() {
        super(255.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public boolean renderSky(ClientLevel world, int ticks, float tickDelta, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.mulPose(modelViewMatrix);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        matrixStack.pushPose();
        this.drawSun(tickDelta, matrixStack, world);
        this.drawMoonPhases(tickDelta, matrixStack, world);
        this.createStars();
        matrixStack.popPose();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        return true;
    }

    private void createStars() {
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starBuffer.bind();
        this.starBuffer.upload(this.drawStars().buildOrThrow());
        VertexBuffer.unbind();
    }

    private BufferBuilder drawStars() {
        RandomSource randomsource = RandomSource.create((long)10842L);
        BufferBuilder pBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d1 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d2 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                pBuilder.addVertex((float)(d5 + d25), (float)(d6 + d23), (float)(d7 + d26));
            }
        }
        return pBuilder;
    }

    public void drawSun(float partialTicks, PoseStack matrix, ClientLevel world) {
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_TEXTURES);
        matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
        matrix.mulPose(Axis.XP.rotationDegrees(world.getTimeOfDay(partialTicks) * 360.0f));
        Matrix4f matrix4f = matrix.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(drawMode, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, -size, 100.0f, -size).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, size, 100.0f, -size).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, size, 100.0f, size).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, -size, 100.0f, size).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void drawMoonPhases(float partialTicks, PoseStack matrix, ClientLevel world) {
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_PHASES_TEXTURES);
        matrix.mulPose(Axis.XP.rotationDegrees(world.getTimeOfDay(partialTicks) * 360.0f * 0.0015f));
        int k1 = world.getMoonPhase();
        int i2 = k1 % 4;
        int k2 = k1 / 4 % 2;
        float f22 = (float)(i2 + 0) / 4.0f;
        float f23 = (float)(k2 + 0) / 2.0f;
        float f24 = (float)(i2 + 1) / 4.0f;
        float f14 = (float)(k2 + 1) / 2.0f;
        Matrix4f matrix4f = matrix.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(drawMode, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, -size, -100.0f, size).setUv(f24, f14);
        bufferbuilder.addVertex(matrix4f, size, -100.0f, size).setUv(f22, f14);
        bufferbuilder.addVertex(matrix4f, size, -100.0f, -size).setUv(f22, f23);
        bufferbuilder.addVertex(matrix4f, -size, -100.0f, -size).setUv(f24, f23);
        BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
    }

    public float getCloudHeight() {
        return 450.0f;
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 p_108908_, float p_108909_) {
        return p_108908_.multiply((double)(p_108909_ * 0.94f + 0.06f), (double)(p_108909_ * 0.94f + 0.06f), (double)(p_108909_ * 0.91f + 0.09f));
    }

    public boolean isFoggyAt(int p_108905_, int p_108906_) {
        return false;
    }
}

