/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mystic.atlantis.Atlantis;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class AtlanteanBiomeSource
extends BiomeSource {
    public static final MapCodec<AtlanteanBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.BIOME).forGetter(AtlanteanBiomeSource::biomeHolderLookup), (App)Codec.intRange((int)1, (int)20).fieldOf("biome_size").orElse((Object)2).forGetter(AtlanteanBiomeSource::biomeSize), (App)Codec.LONG.fieldOf("seed").stable().forGetter(AtlanteanBiomeSource::seed)).apply((Applicative)instance, AtlanteanBiomeSource::new));
    public static final ResourceLocation ATLANTEAN_GARDEN = Atlantis.id("atlantean_garden");
    public static final ResourceLocation ATLANTIS_BIOME = Atlantis.id("atlantis_biome");
    public static final ResourceLocation JELLYFISH_FIELDS = Atlantis.id("jellyfish_fields");
    public static final ResourceLocation ATLANTEAN_ISLANDS = Atlantis.id("atlantean_islands_biome");
    public static final ResourceLocation VOLCANIC_DARKSEA = Atlantis.id("volcanic_darksea");
    public static final ResourceLocation GOO_LAGOONS = Atlantis.id("goo_lagoons");
    public static final ResourceLocation COCONUT_ISLES = Atlantis.id("coconut_isles");
    private final HolderLookup.RegistryLookup<Biome> biomeHolderLookup;
    private final long seed;
    private final int biomeSize;

    public AtlanteanBiomeSource(HolderLookup.RegistryLookup<Biome> biomeRegistry, int biomeSize, long seed) {
        this.biomeHolderLookup = biomeRegistry;
        this.biomeSize = biomeSize;
        this.seed = seed;
    }

    private Holder<Biome> getHolderBiome(ResourceLocation resourceLocationBiome) {
        return this.biomeHolderLookup.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)resourceLocationBiome));
    }

    @NotNull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return Stream.of(GOO_LAGOONS, VOLCANIC_DARKSEA, JELLYFISH_FIELDS, ATLANTIS_BIOME, ATLANTEAN_GARDEN, ATLANTEAN_ISLANDS, COCONUT_ISLES).map(this::getHolderBiome);
    }

    @NotNull
    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler noise) {
        if ((double)((int)noise.sample(x, y, z).temperature()) > 0.5) {
            return this.getHolderBiome(GOO_LAGOONS);
        }
        if ((double)((int)noise.sample(x, y, z).temperature()) > 0.4 && (double)((int)noise.sample(x, y, z).temperature()) < 0.5) {
            return this.getHolderBiome(VOLCANIC_DARKSEA);
        }
        if ((double)((int)noise.sample(x, y, z).temperature()) > 0.3 && (double)noise.sample(x, y, z).temperature() < 0.4) {
            return this.getHolderBiome(JELLYFISH_FIELDS);
        }
        if ((double)((int)noise.sample(x, y, z).temperature()) > 0.2 && (double)noise.sample(x, y, z).temperature() < 0.3) {
            return this.getHolderBiome(ATLANTIS_BIOME);
        }
        if ((double)((int)noise.sample(x, y, z).temperature()) > 0.1 && (double)noise.sample(x, y, z).temperature() < 0.2) {
            if ((double)((int)noise.sample(x, y, z).depth()) == 0.0) {
                return this.getHolderBiome(COCONUT_ISLES);
            }
            return this.getHolderBiome(ATLANTEAN_ISLANDS);
        }
        return this.getHolderBiome(ATLANTEAN_GARDEN);
    }

    public long seed() {
        return this.seed;
    }

    public int biomeSize() {
        return this.biomeSize;
    }

    public HolderLookup.RegistryLookup<Biome> biomeHolderLookup() {
        return this.biomeHolderLookup;
    }
}

