/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public record BlockType(DeferredBlock<Block> block, DeferredBlock<SlabBlock> slab, DeferredBlock<WallBlock> wall, DeferredBlock<FenceBlock> fence, DeferredBlock<FenceGateBlock> fenceGate, DeferredBlock<StairBlock> stairs, DeferredBlock<DoorBlock> door, DeferredBlock<TrapDoorBlock> trapDoor, DeferredBlock<ButtonBlock> button, DeferredBlock<PressurePlateBlock> pressurePlate) {
    private static final Map<BlockType, Supplier<BlockFamily>> MAP = Maps.newHashMap();

    @NotNull
    public static Stream<BlockFamily> getAllFamilies() {
        return MAP.values().stream().map(Supplier::get);
    }

    public static BlockType of(DeferredBlock<Block> blockBase, DeferredBlock<SlabBlock> blockSlab, DeferredBlock<WallBlock> blockWall, DeferredBlock<FenceBlock> blockFence, DeferredBlock<FenceGateBlock> blockGateBlock, DeferredBlock<StairBlock> blockStair, DeferredBlock<DoorBlock> blockDoor, DeferredBlock<TrapDoorBlock> blockTrapDoor, DeferredBlock<ButtonBlock> blockButton, DeferredBlock<PressurePlateBlock> pressurePlate) {
        BlockType blockType = new BlockType(blockBase, blockSlab, blockWall, blockFence, blockGateBlock, blockStair, blockDoor, blockTrapDoor, blockButton, pressurePlate);
        MAP.computeIfAbsent(blockType, blockType1 -> Suppliers.memoize(() -> BlockType.family(blockType1)));
        return blockType;
    }

    public static BlockFamily family(BlockType type) {
        BlockFamily.Builder family = new BlockFamily.Builder((Block)type.block.get());
        if (type.slab != null) {
            family.slab((Block)type.slab.get());
        }
        if (type.stairs != null) {
            family.stairs((Block)type.stairs.get());
        }
        if (type.door != null) {
            family.door((Block)type.door.get());
        }
        if (type.trapDoor != null) {
            family.trapdoor((Block)type.trapDoor.get());
        }
        if (type.pressurePlate != null) {
            family.pressurePlate((Block)type.pressurePlate.get());
        }
        if (type.button != null) {
            family.button((Block)type.button.get());
        }
        if (type.wall != null) {
            family.wall((Block)type.wall.get());
        }
        if (type.fence != null) {
            family.fence((Block)type.fence.get());
        }
        if (type.fenceGate != null) {
            family.fenceGate((Block)type.fenceGate.get());
        }
        return family.getFamily();
    }
}

