/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.ancient_cuprum;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CuprumBulbBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public CuprumBulbBlock(BlockBehaviour.Properties p_308970_) {
        super(p_308970_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.getBlock() != pState.getBlock() && pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            this.checkAndFlip(pState, serverlevel, pPos);
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            this.checkAndFlip(pState, serverlevel, pPos);
        }
    }

    public void checkAndFlip(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        boolean flag = pLevel.hasNeighborSignal(pPos);
        if (flag != (Boolean)pState.getValue((Property)POWERED)) {
            BlockState blockstate = pState;
            if (!((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
                blockstate = (BlockState)pState.cycle((Property)LIT);
            }
            pLevel.setBlock(pPos, (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, POWERED});
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos) {
        return (Boolean)pLevel.getBlockState(pPos).getValue((Property)LIT) != false ? 15 : 0;
    }
}

