/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.ancient_cuprum;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mystic.atlantis.init.BlockInit;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface WeatheringCuprum
extends ChangeOverTimeBlock<WeatherState> {
    public static final Supplier<ImmutableBiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        WeatheringCuprum.link((ImmutableBiMap.Builder<Block, Block>)builder, WeatherState.UNAFFECTED, WeatherState.EXPOSED);
        WeatheringCuprum.link((ImmutableBiMap.Builder<Block, Block>)builder, WeatherState.EXPOSED, WeatherState.WEATHERED);
        WeatheringCuprum.link((ImmutableBiMap.Builder<Block, Block>)builder, WeatherState.WEATHERED, WeatherState.OXIDIZED);
        return builder.build();
    });
    public static final Supplier<ImmutableBiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public static void link(ImmutableBiMap.Builder<Block, Block> builder, WeatherState before, WeatherState after) {
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).block().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).block().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).cut().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).cut().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).chiseled().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).chiseled().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).cut_stairs().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).cut_stairs().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).cut_slab().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).cut_slab().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).door().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).door().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).trapdoor().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).trapdoor().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).grate().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).grate().get()));
        builder.put((Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)before).bulb().get()), (Object)((Block)BlockInit.ANCIENT_CUPRUM.get((Object)after).bulb().get()));
    }

    public static Optional<Block> getPrevious(Block pBlock) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)pBlock));
    }

    public static Optional<BlockState> getPrevious(BlockState pState) {
        return WeatheringCuprum.getPrevious(pState.getBlock()).map(p_154903_ -> p_154903_.withPropertiesOf(pState));
    }

    public static Optional<Block> getNext(Block pBlock) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)pBlock));
    }

    default public Optional<BlockState> getNext(BlockState pState) {
        return WeatheringCuprum.getNext(pState.getBlock()).map(p_154896_ -> p_154896_.withPropertiesOf(pState));
    }

    default public float getChanceModifier() {
        return this.getAge() == WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum WeatherState implements StringRepresentable
    {
        UNAFFECTED("unaffected", 15),
        EXPOSED("exposed", 12),
        WEATHERED("weathered", 8),
        OXIDIZED("oxidized", 4);

        public static final Codec<WeatherState> CODEC;
        private final String name;
        private final int lightLevel;

        private WeatherState(String pName, int lightLevel) {
            this.name = pName;
            this.lightLevel = lightLevel;
        }

        public int lightLevel() {
            return this.lightLevel;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(WeatherState::values);
        }
    }
}

