/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.google.common.collect.Sets;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.mixin.RedstoneAccessor;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class AquaticPowerDustBlock
extends RedStoneWireBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;
    public static final Property<Integer> POWER = RedStoneWireBlock.POWER;
    private static Vec3[] COLOR = (Vec3[])Util.make((Object)new Vec3[16], vec3ds -> {
        for (int i = 0; i <= 15; ++i) {
            float f = (float)i / 15.0f;
            float r = Mth.clamp((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float g = Mth.clamp((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            float b = f * 0.6f + (f > 0.0f ? 0.4f : 0.3f);
            vec3ds[i] = new Vec3((double)r, (double)g, (double)b);
        }
    });

    public AquaticPowerDustBlock(BlockBehaviour.Properties settings) {
        super(settings.noCollission().instabreak());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)RedstoneSide.NONE)).setValue((Property)EAST, (Comparable)RedstoneSide.NONE)).setValue((Property)SOUTH, (Comparable)RedstoneSide.NONE)).setValue((Property)WEST, (Comparable)RedstoneSide.NONE)).setValue(POWER, (Comparable)Integer.valueOf(0))).setValue(WATERLOGGED, (Comparable)Boolean.TRUE));
        ((RedstoneAccessor)((Object)this)).setShouldSignal(true);
    }

    public void animateTick(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        int power = (Integer)targetState.getValue(POWER);
        if (power != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide wireConnection = (RedstoneSide)targetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (wireConnection) {
                    case UP: {
                        this.spawnParticlesAlongLine(level, random, targetPos, COLOR[power], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(level, random, targetPos, COLOR[power], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(level, random, targetPos, COLOR[power], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    private void spawnParticlesAlongLine(Level level, RandomSource random, BlockPos targetPos, Vec3 spawnVec, Direction curDir, Direction targetDir, float of1, float of2) {
        float offsetMod = of2 - of1;
        if (!(random.nextFloat() >= 0.2f * offsetMod)) {
            float offset = of1 + offsetMod * random.nextFloat();
            double targetX = 0.5 + (double)(0.4375f * (float)curDir.getStepX()) + (double)(offset * (float)targetDir.getStepX());
            double targetY = 0.5 + (double)(0.4375f * (float)curDir.getStepY()) + (double)(offset * (float)targetDir.getStepY());
            double targetZ = 0.5 + (double)(0.4375f * (float)curDir.getStepZ()) + (double)(offset * (float)targetDir.getStepZ());
            level.addParticle((ParticleOptions)new DustParticleOptions(spawnVec.toVector3f(), 1.0f), (double)targetPos.getX() + targetX, (double)targetPos.getY() + targetY, (double)targetPos.getZ() + targetZ, 0.0, 0.0, 0.0);
        }
    }

    public int getSignal(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        if (((RedstoneAccessor)((Object)this)).getShouldSignal() && curDir != Direction.DOWN) {
            int power = (Integer)targetState.getValue(POWER);
            if (power == 0) {
                return 0;
            }
            return curDir != Direction.UP && !((RedstoneSide)this.getConnectionState(getter, targetState, targetPos).getValue((Property)PROPERTY_BY_DIRECTION.get(curDir.getOpposite()))).isConnected() ? 0 : power;
        }
        return 0;
    }

    public int getDirectSignal(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        return !((RedstoneAccessor)((Object)this)).getShouldSignal() ? 0 : targetState.getSignal(getter, targetPos, curDir);
    }

    public void updatePowerStrength(Level level, BlockPos targetPos, BlockState targetState) {
        int receivedPower = this.calculateTargetStrength(level, targetPos);
        if ((Integer)targetState.getValue(POWER) != receivedPower) {
            if (level.getBlockState(targetPos) == targetState) {
                level.setBlock(targetPos, (BlockState)targetState.setValue(POWER, (Comparable)Integer.valueOf(receivedPower)), 2);
            }
            HashSet targetPositions = Sets.newHashSet();
            targetPositions.add(targetPos);
            Direction[] validDirections = Direction.values();
            for (Direction direction : validDirections) {
                targetPositions.add(targetPos.relative(direction));
            }
            for (BlockPos targetPosition : targetPositions) {
                level.updateNeighborsAt(targetPosition, (Block)this);
            }
        }
    }

    public int calculateTargetStrength(Level level, BlockPos targetPos) {
        ((RedstoneAccessor)((Object)this)).setShouldSignal(false);
        int receivedPower = level.getBestNeighborSignal(targetPos);
        ((RedstoneAccessor)((Object)this)).setShouldSignal(true);
        int calculatedPower = 0;
        if (receivedPower >= 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.getBlockState(targetPos.relative(direction)).getBlockHolder().value() != Blocks.REDSTONE_WIRE && level.getBlockState(targetPos.relative(direction).below()).getBlockHolder().value() != Blocks.REDSTONE_WIRE && level.getBlockState(targetPos.relative(direction).above()).getBlockHolder().value() != Blocks.REDSTONE_WIRE) continue;
                return Math.max(receivedPower - 1, calculatedPower - 1);
            }
            return receivedPower;
        }
        if (receivedPower >= 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos relativePos = targetPos.relative(direction);
                BlockState relativeState = level.getBlockState(relativePos);
                calculatedPower = Math.max(calculatedPower, this.getWireSignal(relativeState));
                BlockPos aboveTargetPos = targetPos.above();
                if (relativeState.isRedstoneConductor((BlockGetter)level, relativePos) && !level.getBlockState(aboveTargetPos).isRedstoneConductor((BlockGetter)level, aboveTargetPos)) {
                    calculatedPower = Math.max(calculatedPower, this.getWireSignal(level.getBlockState(relativePos.above())));
                    continue;
                }
                if (relativeState.isRedstoneConductor((BlockGetter)level, relativePos)) continue;
                calculatedPower = Math.max(calculatedPower, this.getWireSignal(level.getBlockState(relativePos.below())));
            }
            if (receivedPower == 0) {
                return Math.max(receivedPower, calculatedPower - 1);
            }
            return Math.max(receivedPower - 1, calculatedPower - 1);
        }
        return 0;
    }

    public boolean isSignalSource(BlockState targetState) {
        return ((RedstoneAccessor)((Object)this)).getShouldSignal();
    }

    private int getWireSignal(BlockState targetState) {
        if (targetState.is(Blocks.REDSTONE_WIRE)) {
            return (Integer)targetState.getValue((Property)RedStoneWireBlock.POWER);
        }
        if (targetState.is((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get())) {
            return (Integer)targetState.getValue(POWER);
        }
        return 0;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            BlockPos belowPos = targetPos.below();
            BlockState belowState = reader.getBlockState(belowPos);
            return this.canSurviveOn((BlockGetter)reader, belowPos, belowState);
        }
        return false;
    }

    private boolean canSurviveOn(BlockGetter getter, BlockPos targetPos, BlockState targetFloorState) {
        return targetFloorState.isFaceSturdy(getter, targetPos, Direction.UP) || targetFloorState.is(Blocks.HOPPER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, EAST, NORTH, SOUTH, WEST, POWER});
    }
}

