/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerDustBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AquaticPowerFenceGateBlock
extends FenceGateBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty IN_WALL = BlockStateProperties.IN_WALL;
    protected static final VoxelShape Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape X_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE_LOW = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    protected static final VoxelShape X_SHAPE_LOW = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)13.0, (double)16.0);
    protected static final VoxelShape Z_COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    protected static final VoxelShape X_COLLISION_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)16.0);
    protected static final VoxelShape Z_OCCLUSION_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)5.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)14.0, (double)5.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)16.0, (double)2.0), (VoxelShape)Block.box((double)7.0, (double)5.0, (double)14.0, (double)9.0, (double)16.0, (double)16.0));
    protected static final VoxelShape Z_OCCLUSION_SHAPE_LOW = Shapes.or((VoxelShape)Block.box((double)0.0, (double)2.0, (double)7.0, (double)2.0, (double)13.0, (double)9.0), (VoxelShape)Block.box((double)14.0, (double)2.0, (double)7.0, (double)16.0, (double)13.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE_LOW = Shapes.or((VoxelShape)Block.box((double)7.0, (double)2.0, (double)0.0, (double)9.0, (double)13.0, (double)2.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)13.0, (double)16.0));

    public AquaticPowerFenceGateBlock(BlockBehaviour.Properties settings) {
        super(WoodType.OAK, settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false))).setValue(AquaticPowerDustBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        if (((Boolean)targetState.getValue((Property)IN_WALL)).booleanValue()) {
            return ((Direction)targetState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE_LOW : Z_SHAPE_LOW;
        }
        return ((Direction)targetState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE : Z_SHAPE;
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighbourState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighbourPos) {
        Direction.Axis curAxis = curDir.getAxis();
        if (((Direction)targetState.getValue((Property)FACING)).getClockWise().getAxis() != curAxis) {
            return super.updateShape(targetState, curDir, neighbourState, accessor, targetPos, neighbourPos);
        }
        boolean isNeighbourWall = this.isWall(neighbourState) || this.isWall(accessor.getBlockState(targetPos.relative(curDir.getOpposite())));
        return (BlockState)targetState.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(isNeighbourWall));
    }

    public VoxelShape getCollisionShape(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        if (((Boolean)targetState.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.empty();
        }
        return ((Direction)targetState.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? Z_COLLISION_SHAPE : X_COLLISION_SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState targetState, BlockGetter getter, BlockPos targetPos) {
        if (((Boolean)targetState.getValue((Property)IN_WALL)).booleanValue()) {
            return ((Direction)targetState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_OCCLUSION_SHAPE_LOW : Z_OCCLUSION_SHAPE_LOW;
        }
        return ((Direction)targetState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_OCCLUSION_SHAPE : Z_OCCLUSION_SHAPE;
    }

    public boolean isPathfindable(BlockState targetState, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.WATER -> (Boolean)targetState.getValue((Property)OPEN);
            case PathComputationType.AIR -> false;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        boolean hasNeighbourSignal = level.hasNeighborSignal(clickedPos);
        Direction curHorizontalDir = context.getHorizontalDirection();
        Direction.Axis curAxis = curHorizontalDir.getAxis();
        boolean isClickedStateWallOnZ = curAxis == Direction.Axis.Z && (this.isWall(level.getBlockState(clickedPos.west())) || this.isWall(level.getBlockState(clickedPos.east()))) || curAxis == Direction.Axis.X && (this.isWall(level.getBlockState(clickedPos.north())) || this.isWall(level.getBlockState(clickedPos.south())));
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)curHorizontalDir)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasNeighbourSignal))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasNeighbourSignal))).setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(isClickedStateWallOnZ));
    }

    private boolean isWall(BlockState targetState) {
        return targetState.is(BlockTags.WALLS);
    }

    public InteractionResult useWithoutItem(BlockState targetState, Level level, BlockPos targetPos, Player player, BlockHitResult result) {
        if (((Boolean)targetState.getValue((Property)OPEN)).booleanValue()) {
            targetState = (BlockState)targetState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
            level.setBlock(targetPos, targetState, 10);
        } else {
            Direction curPlayerFacingDir = player.getDirection();
            if (targetState.getValue((Property)FACING) == curPlayerFacingDir.getOpposite()) {
                targetState = (BlockState)targetState.setValue((Property)FACING, (Comparable)curPlayerFacingDir);
            }
            targetState = (BlockState)targetState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
            level.setBlock(targetPos, targetState, 10);
        }
        boolean isOpen = (Boolean)targetState.getValue((Property)OPEN);
        level.levelEvent(player, isOpen ? 1008 : 1014, targetPos, 0);
        level.gameEvent((Entity)player, (Holder)(isOpen ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), targetPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void neighborChanged(BlockState targetState, Level level, BlockPos targetPos, Block targetBlock, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            boolean bl2 = level.hasNeighborSignal(targetPos);
            if ((Boolean)targetState.getValue((Property)POWERED) != bl2) {
                level.setBlock(targetPos, (BlockState)((BlockState)targetState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl2))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(bl2)), 2);
                if ((Boolean)targetState.getValue((Property)OPEN) != bl2) {
                    level.levelEvent(null, bl2 ? 1008 : 1014, targetPos, 0);
                    level.gameEvent(null, (Holder)(bl2 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), targetPos);
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, IN_WALL, AquaticPowerDustBlock.WATERLOGGED});
    }

    public static boolean connectsToDirection(BlockState targetState, Direction targetDir) {
        return ((Direction)targetState.getValue((Property)FACING)).getAxis() == targetDir.getClockWise().getAxis();
    }
}

