/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.plants.Seabloom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class AquaticPowerLeverBlock
extends LeverBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;
    public static final Vector3f COLOR = Vec3.fromRGB24((int)255).toVector3f();

    public AquaticPowerLeverBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            BlockState blockstate = (BlockState)state.cycle((Property)POWERED);
            if (((Boolean)blockstate.getValue((Property)POWERED)).booleanValue()) {
                AquaticPowerLeverBlock.makeParticle(blockstate, (LevelAccessor)level, pos, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        this.pull(state, level, pos, null);
        return InteractionResult.CONSUME;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    private static void makeParticle(BlockState targetState, LevelAccessor accessor, BlockPos targetPos, float alpha) {
        Direction oppositeDir = ((Direction)targetState.getValue((Property)FACING)).getOpposite();
        Direction connectedDir = AquaticPowerLeverBlock.getConnectedDirection((BlockState)targetState).getOpposite();
        double targetX = (double)targetPos.getX() + 0.5 + 0.1 * (double)oppositeDir.getStepX() + 0.2 * (double)connectedDir.getStepX();
        double targetY = (double)targetPos.getY() + 0.5 + 0.1 * (double)oppositeDir.getStepY() + 0.2 * (double)connectedDir.getStepY();
        double targetZ = (double)targetPos.getZ() + 0.5 + 0.1 * (double)oppositeDir.getStepZ() + 0.2 * (double)connectedDir.getStepZ();
        accessor.addParticle((ParticleOptions)new DustParticleOptions(COLOR, alpha), targetX, targetY, targetZ, 0.0, 0.0, 0.0);
    }

    public void animateTick(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        if (((Boolean)targetState.getValue((Property)POWERED)).booleanValue() && random.nextFloat() < 0.25f) {
            AquaticPowerLeverBlock.makeParticle(targetState, (LevelAccessor)level, targetPos, 0.5f);
        }
    }

    public static boolean canAttach(LevelReader reader, BlockPos targetPos, Direction curDir) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            BlockPos relativePos = targetPos.relative(curDir);
            return reader.getBlockState(relativePos).isFaceSturdy((BlockGetter)reader, relativePos, curDir.getOpposite());
        }
        return false;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACE, FACING, POWERED, WATERLOGGED});
    }
}

