/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.plants.Seabloom;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AquaticPowerPressurePlateBlock
extends PressurePlateBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;
    private static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final BlockSetType.PressurePlateSensitivity sensitivity;

    public AquaticPowerPressurePlateBlock(BlockSetType.PressurePlateSensitivity sensitivity, BlockBehaviour.Properties settings) {
        super(BlockSetType.OAK, settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivity;
    }

    protected int getSignalForState(BlockState targetState) {
        return (Boolean)targetState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState targetState, int power) {
        return (BlockState)targetState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(power > 0));
    }

    protected int getSignalStrength(Level level, BlockPos targetPos) {
        List touchingEntities;
        AABB touchableAABB = TOUCH_AABB.move(targetPos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                touchingEntities = level.getEntities(null, touchableAABB);
                break;
            }
            case MOBS: {
                touchingEntities = level.getEntitiesOfClass(LivingEntity.class, touchableAABB);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!touchingEntities.isEmpty()) {
            for (Entity nextEntity : touchingEntities) {
                if (nextEntity.isIgnoringBlockTriggers()) continue;
                return 15;
            }
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, WATERLOGGED});
    }
}

