/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerLeverBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AquaticPowerRepeaterBlock
extends RepeaterBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;

    public AquaticPowerRepeaterBlock(BlockBehaviour.Properties settings) {
        super(settings.instabreak().sound(SoundType.WOOD));
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            BlockPos belowPos = targetPos.below();
            BlockState belowState = reader.getBlockState(belowPos);
            return this.canRunOnTop((BlockGetter)reader, belowPos, belowState);
        }
        return false;
    }

    public void animateTick(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        if (((Boolean)targetState.getValue((Property)POWERED)).booleanValue()) {
            Direction facingDir = (Direction)targetState.getValue((Property)FACING);
            double targetX = (double)targetPos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double targetY = (double)targetPos.getY() + 0.4 + (random.nextDouble() - 0.5) * 0.2;
            double targetZ = (double)targetPos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            float potentialDelay = -5.0f;
            if (random.nextBoolean()) {
                potentialDelay = (Integer)targetState.getValue((Property)DELAY) * 2 - 1;
            }
            double dX = (potentialDelay /= 16.0f) * (float)facingDir.getStepX();
            double dZ = potentialDelay * (float)facingDir.getStepZ();
            level.addParticle((ParticleOptions)new DustParticleOptions(AquaticPowerLeverBlock.COLOR, 1.0f), targetX + dX, targetY, targetZ + dZ, 0.0, 0.0, 0.0);
        }
    }

    private boolean canRunOnTop(BlockGetter getter, BlockPos targetPos, BlockState targetFloorState) {
        return targetFloorState.isFaceSturdy(getter, targetPos, Direction.UP) || targetFloorState.is(Blocks.HOPPER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, DELAY, LOCKED, POWERED});
    }
}

