/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class AquaticPowerStoneBlock
extends PoweredBlock {
    public AquaticPowerStoneBlock(BlockBehaviour.Properties settings) {
        super(settings.sound(SoundType.STONE).mapColor(MapColor.COLOR_BLUE));
    }

    public int getSignal(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        if (this.isSubmergedInWater(getter, targetPos)) {
            return 15;
        }
        return 0;
    }

    public void neighborChanged(BlockState targetState, Level level, BlockPos targetPos, Block targetBlock, BlockPos fromPos, boolean notify) {
        if (!level.isClientSide) {
            this.getSignal(targetState, (BlockGetter)level, targetPos, Direction.UP);
            super.neighborChanged(targetState, level, targetPos, targetBlock, fromPos, true);
        }
    }

    public boolean isSubmergedInWater(BlockGetter getter, BlockPos targetPos) {
        return getter.getBlockState(targetPos.east()).is(Blocks.WATER) || getter.getBlockState(targetPos.west()).is(Blocks.WATER) || getter.getBlockState(targetPos.north()).is(Blocks.WATER) || getter.getBlockState(targetPos.south()).is(Blocks.WATER) || getter.getBlockState(targetPos.above()).is(Blocks.WATER);
    }
}

