/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerLeverBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AquaticPowerTorchBlock
extends RedstoneTorchBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;

    public AquaticPowerTorchBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(value -> (Boolean)value.getValue((Property)LIT) != false ? 7 : 0).noCollission().sound(SoundType.WOOD).instabreak());
        this.defaultBlockState().setValue(WATERLOGGED, (Comparable)Boolean.FALSE);
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor world, BlockPos targetPos, BlockPos neighborPos) {
        return curDir == Direction.DOWN && !this.canSurvive(targetState, (LevelReader)world, targetPos) ? Blocks.WATER.defaultBlockState() : super.updateShape(targetState, curDir, neighborState, world, targetPos, neighborPos);
    }

    public void animateTick(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        if (((Boolean)targetState.getValue((Property)LIT)).booleanValue()) {
            double targetX = (double)targetPos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double targetY = (double)targetPos.getY() + 0.7 + (random.nextDouble() - 0.5) * 0.2;
            double targetZ = (double)targetPos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            level.addParticle((ParticleOptions)new DustParticleOptions(AquaticPowerLeverBlock.COLOR, 1.0f), targetX, targetY, targetZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            return AquaticPowerTorchBlock.canSupportCenter((LevelReader)reader, (BlockPos)targetPos.below(), (Direction)Direction.UP);
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, LIT});
    }
}

