/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTripwireHook;
import com.mystic.atlantis.blocks.plants.Seabloom;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AquaticPowerTripwireBlock
extends TripWireBlock
implements SimpleWaterloggedBlock {
    private static final Map<Direction, BooleanProperty> FACING_PROPERTIES = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).getAxis().isHorizontal()).collect(Util.toMap());
    private final AquaticPowerTripwireHook hookBlock;
    private static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;

    public AquaticPowerTripwireBlock(AquaticPowerTripwireHook hookBlock, BlockBehaviour.Properties settings) {
        super((Block)hookBlock, settings.instabreak());
        this.hookBlock = hookBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)DISARMED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        return curDir.getAxis().isHorizontal() ? (BlockState)targetState.setValue((Property)FACING_PROPERTIES.get(curDir), (Comparable)Boolean.valueOf(this.shouldConnectTo(neighborState, curDir))) : super.updateShape(targetState, curDir, neighborState, accessor, targetPos, neighborPos);
    }

    public boolean shouldConnectTo(BlockState targetState, Direction facingDir) {
        if (targetState.getFluidState().is(FluidTags.WATER)) {
            if (targetState.is((Block)this.hookBlock)) {
                return targetState.getValue((Property)AquaticPowerTripwireHook.FACING) == facingDir.getOpposite();
            }
            return targetState.is((Block)this);
        }
        return false;
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }
}

