/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTorchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AquaticPowerTripwireHook
extends TripWireHookBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = AquaticPowerTorchBlock.WATERLOGGED;

    public AquaticPowerTripwireHook(BlockBehaviour.Properties settings) {
        super(settings.instabreak());
        this.defaultBlockState().setValue(WATERLOGGED, (Comparable)Boolean.TRUE);
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        return curDir.getOpposite() == targetState.getValue((Property)FACING) && !targetState.canSurvive((LevelReader)accessor, targetPos) ? Blocks.WATER.defaultBlockState() : super.updateShape(targetState, curDir, neighborState, accessor, targetPos, neighborPos);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, ATTACHED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState targetState) {
        return (Boolean)targetState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(targetState);
    }

    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            Direction facingDir = (Direction)targetState.getValue((Property)FACING);
            BlockPos relativePos = targetPos.relative(facingDir.getOpposite());
            BlockState relativeState = reader.getBlockState(relativePos);
            return facingDir.getAxis().isHorizontal() && relativeState.isFaceSturdy((BlockGetter)reader, relativePos, facingDir);
        }
        return false;
    }
}

