/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.init.AtlantisEntityInit;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SodiumPrimedBombBlock
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.defineId(SodiumPrimedBombBlock.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity owner;

    public SodiumPrimedBombBlock(EntityType<? extends SodiumPrimedBombBlock> type, Level level) {
        super(type, level);
    }

    public SodiumPrimedBombBlock(Level level, double targetX, double targetY, double targetZ, @Nullable LivingEntity owner) {
        this((EntityType<? extends SodiumPrimedBombBlock>)((EntityType)AtlantisEntityInit.SODIUM_BOMB.get()), level);
        this.setPos(targetX, targetY, targetZ);
        double randOffset = level.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(randOffset) * 0.02, 0.2f, -Math.cos(randOffset) * 0.02);
        this.setFuse(80);
        this.xo = targetX;
        this.yo = targetY;
        this.zo = targetZ;
        this.owner = owner;
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FUSE_ID, (Object)80);
    }

    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, this.isUnderWater(), Level.ExplosionInteraction.BLOCK);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putShort("Fuse", (short)this.getFuse());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.setFuse(nbt.getShort("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public double getEyeY() {
        return 0.15f;
    }

    public void setFuse(int fuse) {
        this.entityData.set(DATA_FUSE_ID, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(DATA_FUSE_ID);
    }
}

