/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerTorchBlock;
import com.mystic.atlantis.init.BlockInit;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallAquaticPowerTorchBlock
extends AquaticPowerTorchBlock {
    private static final Property<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Property<Boolean> WATERLOGGED = AquaticPowerTorchBlock.WATERLOGGED;
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallAquaticPowerTorchBlock(BlockBehaviour.Properties settings) {
        super(settings.lootFrom(BlockInit.AQUATIC_POWER_TORCH).noCollission().instabreak().lightLevel(level -> 7).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        return curDir.getOpposite() == targetState.getValue(FACING) && !this.canSurvive(targetState, (LevelReader)accessor, targetPos) ? Blocks.WATER.defaultBlockState() : targetState;
    }

    @Override
    public boolean canSurvive(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.getFluidState(targetPos).is(FluidTags.WATER)) {
            return this.canSurvive(targetState, reader, targetPos);
        }
        return false;
    }

    protected boolean hasNeighborSignal(Level level, BlockPos targetPos, BlockState targetState) {
        Direction facingDir = ((Direction)targetState.getValue(FACING)).getOpposite();
        return level.hasSignal(targetPos.relative(facingDir), facingDir);
    }

    public int getSignal(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        return (Boolean)targetState.getValue((Property)LIT) != false && targetState.getValue(FACING) != curDir ? 15 : 0;
    }

    public BlockState rotate(BlockState targetState, Rotation currentRot) {
        return (BlockState)targetState.setValue(FACING, (Comparable)currentRot.rotate((Direction)targetState.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return WallAquaticPowerTorchBlock.getBoundingShape(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] var6 = directions = ctx.getNearestLookingDirections();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction = var6[var8];
            if (!direction.getAxis().isHorizontal()) continue;
            Direction direction2 = direction.getOpposite();
            blockState = (BlockState)((BlockState)blockState.setValue(FACING, (Comparable)direction2)).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (worldView.getFluidState(blockPos).is(FluidTags.WATER) && this.canSurvive(blockState, (LevelReader)worldView, blockPos)) {
                return blockState;
            }
            return blockState;
        }
        return null;
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.getValue(FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }
}

