/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.blockentities.AtlanteanPortalBlockEntity;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.dimension.AtlanteanPortalForcer;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AtlanteanPortalBlock
extends EndPortalBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public BlockEntity newBlockEntity(BlockPos p_153196_, BlockState p_153197_) {
        return new AtlanteanPortalBlockEntity(p_153196_, p_153197_);
    }

    public void animateTick(BlockState p_221102_, Level p_221103_, BlockPos p_221104_, RandomSource p_221105_) {
        double d0 = (double)p_221104_.getX() + p_221105_.nextDouble();
        double d1 = (double)p_221104_.getY() + 0.8;
        double d2 = (double)p_221104_.getZ() + p_221105_.nextDouble();
        p_221103_.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public AtlanteanPortalBlock(BlockBehaviour.Properties settings) {
        super(settings.noCollission().noOcclusion().sound(SoundType.GLASS).strength(0.2f, 0.4f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pLevel instanceof ServerLevel && Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)pEntity.getBoundingBox().move((double)(-pPos.getX()), (double)(-pPos.getY()), (double)(-pPos.getZ()))), (VoxelShape)pState.getShape((BlockGetter)pLevel, pPos), (BooleanOp)BooleanOp.AND)) {
            ResourceKey<Level> resourcekey = AtlantisDimensions.isAtlantisDimension(pLevel) ? Level.OVERWORLD : AtlantisDimensions.ATLANTIS_WORLD;
            ResourceKey<Level> resourcekey2 = !AtlantisDimensions.isAtlantisDimension(pLevel) ? Level.OVERWORLD : AtlantisDimensions.ATLANTIS_WORLD;
            ServerLevel serverlevel = ((ServerLevel)pLevel).getServer().getLevel(resourcekey);
            ServerLevel serverlevel2 = ((ServerLevel)pLevel).getServer().getLevel(resourcekey2);
            if (serverlevel == null && serverlevel2 == null) {
                return;
            }
            assert (serverlevel2 != null);
            assert (serverlevel != null);
            AtlanteanPortalForcer portalForcer = new AtlanteanPortalForcer(serverlevel);
            if (pEntity.canChangeDimensions((Level)serverlevel, (Level)serverlevel2)) {
                if (pEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pEntity;
                    if (resourcekey.equals(AtlantisDimensions.ATLANTIS_WORLD) && pEntity.getPortalCooldown() == 0) {
                        player.changeDimension(new DimensionTransition(serverlevel, (Entity)player, DimensionTransition.PLAY_PORTAL_SOUND));
                        player.setPortalCooldown(300);
                        if (portalForcer.findPortalAround(player.blockPosition(), false, serverlevel.getWorldBorder()).equals(Optional.empty())) {
                            portalForcer.createPortal(player.blockPosition(), Direction.Axis.X);
                        } else {
                            portalForcer.teleportToPortal(player.blockPosition(), false, serverlevel.getWorldBorder(), player);
                        }
                    } else if (player.getPortalCooldown() == 0) {
                        player.changeDimension(new DimensionTransition(serverlevel, (Entity)player, DimensionTransition.PLAY_PORTAL_SOUND));
                        player.setPortalCooldown(300);
                        if (portalForcer.findPortalAround(player.blockPosition(), true, serverlevel.getWorldBorder()).equals(Optional.empty())) {
                            portalForcer.createPortal(player.blockPosition(), Direction.Axis.X);
                        } else {
                            portalForcer.teleportToPortal(player.blockPosition(), true, serverlevel.getWorldBorder(), player);
                        }
                    }
                } else if (resourcekey.equals(AtlantisDimensions.ATLANTIS_WORLD) && pEntity.getPortalCooldown() == 0) {
                    pEntity.changeDimension(new DimensionTransition(serverlevel, pEntity, DimensionTransition.PLAY_PORTAL_SOUND));
                    pEntity.setPortalCooldown(300);
                    if (portalForcer.findPortalAround(pEntity.blockPosition(), false, serverlevel.getWorldBorder()).equals(Optional.empty())) {
                        portalForcer.createPortal(pEntity.blockPosition(), Direction.Axis.X);
                    } else {
                        portalForcer.teleportToPortal(pEntity.blockPosition(), false, serverlevel.getWorldBorder(), pEntity);
                    }
                } else if (pEntity.getPortalCooldown() == 0) {
                    pEntity.changeDimension(new DimensionTransition(serverlevel, pEntity, DimensionTransition.PLAY_PORTAL_SOUND));
                    pEntity.setPortalCooldown(300);
                    if (portalForcer.findPortalAround(pEntity.blockPosition(), true, serverlevel.getWorldBorder()).equals(Optional.empty())) {
                        portalForcer.createPortal(pEntity.blockPosition(), Direction.Axis.X);
                    } else {
                        portalForcer.teleportToPortal(pEntity.blockPosition(), true, serverlevel.getWorldBorder(), pEntity);
                    }
                }
            }
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.dimensionType().natural() && pLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && pRandom.nextInt(2000) < pLevel.getDifficulty().getId()) {
            Entity entity;
            while (pLevel.getBlockState(pPos).is((Block)this)) {
                pPos = pPos.below();
            }
            if (pLevel.getBlockState(pPos).isValidSpawn((BlockGetter)pLevel, pPos, EntityType.DROWNED) && (entity = EntityType.DROWNED.spawn(pLevel, pPos.above(), MobSpawnType.STRUCTURE)) != null) {
                entity.setPortalCooldown();
            }
        }
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return blockstate;
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue(Seabloom.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, Seabloom.WATERLOGGED});
    }
}

