/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.google.common.base.Predicates;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.init.BlockInit;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class AtlanteanPortalFrame
extends EndPortalFrameBlock
implements SimpleWaterloggedBlock {
    private static BlockPattern portalShape;
    public static final Property<Boolean> WATERLOGGED;

    public AtlanteanPortalFrame() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.GLASS).lightLevel(p_50847_ -> 1).strength(3.0f, 100000.0f));
        this.defaultBlockState().setValue(WATERLOGGED, (Comparable)Boolean.FALSE);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return blockstate;
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue(WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static BlockPattern getOrCreatePortalShape() {
        if (portalShape == null) {
            portalShape = BlockPatternBuilder.start().aisle(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).where('?', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get())).where((Property)HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH)))).where('>', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get())).where((Property)HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST)))).where('v', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get())).where((Property)HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH)))).where('<', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get())).where((Property)HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST)))).build();
        }
        return portalShape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, HAS_EYE, WATERLOGGED});
    }

    static {
        WATERLOGGED = Seabloom.WATERLOGGED;
    }
}

