/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.base.PushBubbleColumnBlock;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BubbleMagmaBlock
extends Block {
    public BubbleMagmaBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void tick(BlockState targetState, ServerLevel level, BlockPos targetPos, RandomSource random) {
        PushBubbleColumnBlock.update(level, targetPos);
    }

    public BlockState updateShape(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor world, BlockPos targetPos, BlockPos neighborPos) {
        if (curDir == Direction.UP || curDir == Direction.DOWN || curDir == Direction.NORTH || curDir == Direction.SOUTH || curDir == Direction.EAST || curDir == Direction.WEST && (neighborState.is(Blocks.WATER) || neighborState.is((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()))) {
            world.scheduleTick(targetPos, (Block)this, 20);
        }
        return super.updateShape(targetState, curDir, neighborState, world, targetPos, neighborPos);
    }

    public void onPlace(BlockState targetState, Level level, BlockPos targetPos, BlockState oldState, boolean notify) {
        level.scheduleTick(targetPos, (Block)this, 20);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion pExplosion) {
        if (!level.isClientSide()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }
}

